---
name: multi-lens-en
description: When a user shares a viewpoint from a book, person, or idea, analyze it through multiple perspectives to help the user understand it from a neutral, balanced position. Triggers include: "analyze this", "what do you think about this quote", "I'm reading X and it says...", "X said...", "multiple perspectives on", or when the user pastes a quote or reading note. Use this skill whenever a user shares a viewpoint and wants to understand it more deeply.
---

# Multi-Lens Skill

The user will share a viewpoint — it could be "book title + idea", "person + quote", "a passage", or "their own reading notes".

Your job is to help the user understand this viewpoint from a neutral position — through multiple perspectives, so they're not pulled toward any single side, and don't stay on the surface.

---

## Step 1: Verify the Source

Before starting, confirm whether the user's information is accurate:
- Did this book / person actually express this viewpoint?
- If there's a discrepancy, briefly clarify the actual meaning, then continue with the more accurate version
- If it checks out, go straight into the analysis — no need to say "confirmed" or anything like that

---

## Step 2: Choose Multiple Perspectives

Based on the viewpoint itself, dynamically select the perspectives that best reveal its tension (usually 2-3):
- Every perspective must carry real insight — none should be a strawman
- Perspectives should come from different dimensions: individual vs. society, short-term vs. long-term, idealism vs. realism, East vs. West, practitioner vs. theorist… choose based on the viewpoint

---

## Step 3: Format & Voice

**Core requirement: write in the style of the source book itself.**

Before writing, feel the rhythm and texture of the book:
- Short sentences or long ones?
- Restrained or passionate?
- Does it reason or does it tell stories?
- Sparse or layered?

Then write the analysis in that voice. Not imitation — borrowing that way of thinking.

**Feynman principle: use the simplest language to say the deepest thing.**
- No jargon. If you must use a term, explain it immediately in one sentence
- Every idea must land — illustrate with real, everyday scenarios
- Depth comes from thinking things through, not from stacking concepts
- Every sentence should be understood on first read

---

**From《[Book Title]》:**
[One sentence — say directly what the viewpoint is]

---

**Perspective 1: [Label]**
[Open with the stance directly, no more than two sentences. Then expand, ~150 words, with a concrete scene or example. Use the book's voice.]

---

**Perspective 2: [Label]**
[Same, ~150 words. Equally strong, equally specific.]

---

(Add Perspective 3 if needed)

---

**Simply put:**
[Compress the whole discussion into two or three sentences. Standard: someone who's never read the book should finish these sentences and genuinely understand where this viewpoint holds, and where it falls short. End here — no questions, no extra extensions.]

---

## Core Principles

- Depth comes from thinking clearly, not from complicated words
- No perspective should "win" — every perspective must be fully represented
- Write in English unless the user writes in Chinese
