---
name: lokuli-booking
description: Book real-world services through Lokuli MCP. Use when user needs to find, check availability, or book local services like plumbers, electricians, cleaners, mechanics, barbers, personal trainers, etc. Triggers on requests like "book me a haircut", "find a plumber near me", "I need a smog check", "schedule a massage", or any local service request. 75+ service categories available.
---

# Lokuli Service Booking

Book real services through Lokuli's MCP server.

## MCP Endpoint

```
https://lokuli.com/mcp/sse
```

Transport: SSE | JSON-RPC 2.0 | POST requests

## Tools

### search
Find services by query and location.
```json
{
  "method": "tools/call",
  "params": {
    "name": "search",
    "arguments": {
      "query": "smog check",
      "zipCode": "90640",
      "category": "Auto Services",
      "maxResults": 20
    }
  }
}
```
- `query` (required): What to search for
- `zipCode`: ZIP code to search near
- `category`: One of: Auto Services, Music & Audio, Beauty Services, Health & Wellness, Tattoo & Body Art, Tech Repair, Tutoring & Education, Home Services, Photography & Video, Events
- `maxResults`: 1-50, default 20

### fetch
Get detailed provider info.
```json
{
  "method": "tools/call",
  "params": {
    "name": "fetch",
    "arguments": {
      "id": "provider_id_from_search"
    }
  }
}
```

### check_availability
Get available time slots.
```json
{
  "method": "tools/call",
  "params": {
    "name": "check_availability",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "date": "2025-02-10"
    }
  }
}
```

### create_booking
Book and get Stripe payment link.
```json
{
  "method": "tools/call",
  "params": {
    "name": "create_booking",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "timeSlot": "2025-02-10T14:00:00-08:00",
      "customerName": "John Doe",
      "customerEmail": "john@example.com",
      "customerPhone": "+13105551234"
    }
  }
}
```
Returns Stripe checkout URL for payment.

### get_booking
Check booking status.
```json
{
  "method": "tools/call",
  "params": {
    "name": "get_booking",
    "arguments": {
      "bookingId": "stripe_session_id"
    }
  }
}
```

### get_service_catalog
List all 75+ service types.
```json
{
  "method": "tools/call",
  "params": {
    "name": "get_service_catalog",
    "arguments": {
      "category": "All"
    }
  }
}
```

### get_pricing_estimates
Get typical pricing for a service.
```json
{
  "method": "tools/call",
  "params": {
    "name": "get_pricing_estimates",
    "arguments": {
      "serviceType": "smog check"
    }
  }
}
```

### validate_location
Check if ZIP code is serviceable.
```json
{
  "method": "tools/call",
  "params": {
    "name": "validate_location",
    "arguments": {
      "zipCode": "90640"
    }
  }
}
```

### create_cart
Create AP2 cart with JWT-signed mandate (alternative to direct checkout).
```json
{
  "method": "tools/call",
  "params": {
    "name": "create_cart",
    "arguments": {
      "shopId": "provider_id",
      "services": [
        {"sku": "service_id", "name": "Smog Check", "price": 39.99, "quantity": 1}
      ]
    }
  }
}
```

## Categories

- **Auto Services**: Smog Check, Oil Change, Detailing, Mechanic, Tires
- **Music & Audio**: Recording Studios, Music Lessons, DJ Services
- **Beauty Services**: Barber, Hair Salon, Nails, Makeup
- **Health & Wellness**: Massage, Chiropractor, Personal Training
- **Tattoo & Body Art**: Tattoo, Piercing
- **Tech Repair**: Phone Repair, Computer Repair
- **Tutoring & Education**: Tutoring, Test Prep, Language
- **Home Services**: Plumber, Electrician, HVAC, Cleaning
- **Photography & Video**: Photography, Videography
- **Events**: Catering, Event Planning

## Workflow

1. **Understand** — What service? Where (ZIP)?
2. **Search** — Find matching providers
3. **Present** — Show top results with pricing
4. **Fetch** — Get details on selected provider
5. **Check availability** — Get open time slots
6. **Confirm** — Get explicit user approval
7. **Create booking** — Generate Stripe checkout
8. **Share link** — User completes payment

## Rules

- **Never book without confirmation** — Always get explicit approval
- **Show pricing upfront** — Use get_pricing_estimates if needed
- **Collect required info** — Name, email, phone before booking
- **Default to user's ZIP** — If known from context
