---
name: book-beauty
description: Book beauty services through Lokuli MCP. Use when user needs haircuts, barbers, hair salons, nails, makeup, spa treatments, or any beauty service. Triggers on requests like "book me a haircut", "find a barber near me", "nail salon appointment", "makeup artist", or any beauty service request.
---

# Book Beauty Services

Book beauty services through Lokuli's MCP server.

## MCP Endpoint

```
https://lokuli.com/mcp/sse
```

Transport: SSE | JSON-RPC 2.0 | POST requests

## Beauty Services Available

- Barber
- Hair Salon
- Nails / Manicure / Pedicure
- Makeup Artist
- Spa Treatments
- Waxing
- Facials
- Eyebrow Threading

## Tools

### search
```json
{
  "method": "tools/call",
  "params": {
    "name": "search",
    "arguments": {
      "query": "haircut",
      "zipCode": "90640",
      "category": "Beauty Services",
      "maxResults": 20
    }
  }
}
```

### check_availability
```json
{
  "method": "tools/call",
  "params": {
    "name": "check_availability",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "date": "2025-02-10"
    }
  }
}
```

### create_booking
```json
{
  "method": "tools/call",
  "params": {
    "name": "create_booking",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "timeSlot": "2025-02-10T14:00:00-08:00",
      "customerName": "John Doe",
      "customerEmail": "john@example.com",
      "customerPhone": "+13105551234"
    }
  }
}
```

## Workflow

1. **Understand** — What beauty service? Where (ZIP)?
2. **Search** — Find matching providers
3. **Present** — Show top results with pricing
4. **Check availability** — Get open time slots
5. **Confirm** — Get explicit user approval
6. **Create booking** — Generate checkout link
