---
name: book-auto
description: Book auto services through Lokuli MCP. Use when user needs smog checks, oil changes, car detailing, mechanics, tire services, or any automotive service. Triggers on requests like "I need a smog check", "book an oil change", "find a mechanic near me", "car detailing", or any auto service request.
---

# Book Auto Services

Book automotive services through Lokuli's MCP server.

## MCP Endpoint

```
https://lokuli.com/mcp/sse
```

Transport: SSE | JSON-RPC 2.0 | POST requests

## Auto Services Available

- Smog Check
- Oil Change
- Car Detailing
- Mechanic
- Tire Services
- Brake Service
- Car Wash
- Auto Body Repair

## Tools

### search
```json
{
  "method": "tools/call",
  "params": {
    "name": "search",
    "arguments": {
      "query": "smog check",
      "zipCode": "90640",
      "category": "Auto Services",
      "maxResults": 20
    }
  }
}
```

### check_availability
```json
{
  "method": "tools/call",
  "params": {
    "name": "check_availability",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "date": "2025-02-10"
    }
  }
}
```

### create_booking
```json
{
  "method": "tools/call",
  "params": {
    "name": "create_booking",
    "arguments": {
      "providerId": "xxx",
      "serviceId": "yyy",
      "timeSlot": "2025-02-10T14:00:00-08:00",
      "customerName": "John Doe",
      "customerEmail": "john@example.com",
      "customerPhone": "+13105551234"
    }
  }
}
```

## Workflow

1. **Understand** — What auto service? Where (ZIP)?
2. **Search** — Find matching providers
3. **Present** — Show top results with pricing
4. **Check availability** — Get open time slots
5. **Confirm** — Get explicit user approval
6. **Create booking** — Generate checkout link
