#!/bin/bash

# Bocha Search Skill 发布脚本
# 使用方法: ./publish.sh

set -e

echo "🚀 开始发布 Bocha Search Skill 到 ClawdHub..."
echo ""

# 颜色定义
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m' # No Color

# 检查 clawdhub 是否安装
if ! command -v clawdhub &> /dev/null; then
    echo -e "${YELLOW}⚠️  clawdhub CLI 未安装，正在安装...${NC}"
    npm install -g clawdhub
fi

# 检查是否已登录
echo -e "${BLUE}🔍 检查登录状态...${NC}"
if ! clawdhub whoami &> /dev/null; then
    echo -e "${YELLOW}⚠️  未登录到 ClawdHub${NC}"
    echo ""
    echo "请选择登录方式:"
    echo "1. 浏览器登录 (推荐)"
    echo "2. 使用 API Token 登录"
    echo ""
    read -p "请输入选项 (1 或 2): " choice
    
    if [ "$choice" = "1" ]; then
        echo -e "${BLUE}🌐 正在打开浏览器登录...${NC}"
        clawdhub login
    elif [ "$choice" = "2" ]; then
        echo ""
        echo "获取 API Token 步骤:"
        echo "1. 访问 https://clawdhub.com"
        echo "2. 登录你的账号"
        echo "3. 进入 Settings > API Tokens"
        echo "4. 创建新的 Token"
        echo ""
        read -p "请输入你的 API Token: " token
        clawdhub login --token "$token"
    else
        echo -e "${RED}❌ 无效选项${NC}"
        exit 1
    fi
fi

echo -e "${GREEN}✅ 已登录到 ClawdHub${NC}"
echo ""

# 获取当前版本
CURRENT_VERSION=$(grep -o '"version": "[^"]*"' scripts/package.json | cut -d'"' -f4)
echo -e "${BLUE}📦 当前版本: $CURRENT_VERSION${NC}"
echo ""

# 询问版本号
read -p "请输入新版本号 (直接回车使用 $CURRENT_VERSION): " new_version
VERSION=${new_version:-$CURRENT_VERSION}

# 询问更新说明
echo ""
read -p "请输入版本更新说明: " changelog

if [ -z "$changelog" ]; then
    changelog="Update version $VERSION"
fi

# 确认发布
echo ""
echo -e "${YELLOW}📋 发布信息确认:${NC}"
echo "  Skill 名称: Bocha Search"
echo "  Slug: bocha-search"
echo "  版本: $VERSION"
echo "  更新说明: $changelog"
echo ""
read -p "确认发布? (y/N): " confirm

if [ "$confirm" != "y" ] && [ "$confirm" != "Y" ]; then
    echo -e "${RED}❌ 发布已取消${NC}"
    exit 0
fi

# 执行发布
echo ""
echo -e "${BLUE}🚀 正在发布...${NC}"
echo ""

clawdhub publish . \
    --slug bocha-search \
    --name "Bocha Search" \
    --version "$VERSION" \
    --changelog "$changelog" \
    --tags "search,chinese,bocha,web,ai-search,news,中文搜索"

echo ""
echo -e "${GREEN}✅ 发布成功!${NC}"
echo ""
echo "你可以在以下地址查看:"
echo "  https://clawdhub.com/skill/bocha-search"
echo ""
echo "其他用户现在可以通过以下命令安装:"
echo "  clawdhub install bocha-search"
echo ""