# 快速发布指南

由于当前环境限制，请在你的本地机器上执行以下步骤来发布 skill。

## 方法一：使用发布脚本（推荐）

### 1. 复制 skill 到本地

首先，将整个 `bocha-search` 文件夹复制到你的本地机器。

### 2. 运行发布脚本

```bash
cd bocha-search
chmod +x publish.sh
./publish.sh
```

脚本会引导你完成：
- ✅ 安装 clawdhub CLI（如未安装）
- ✅ 登录 ClawdHub
- ✅ 输入版本号和更新说明
- ✅ 自动发布

## 方法二：手动命令发布

### 1. 安装 ClawdHub CLI

```bash
npm install -g clawdhub
```

### 2. 登录

**方式 A - 浏览器登录（推荐）:**
```bash
clawdhub login
```

**方式 B - Token 登录:**
```bash
# 访问 https://clawdhub.com → Settings → API Tokens 获取 token
clawdhub login --token "your-api-token-here"
```

### 3. 进入 skill 目录

```bash
cd /path/to/bocha-search
```

### 4. 发布

```bash
clawdhub publish . \
  --slug bocha-search \
  --name "Bocha Search" \
  --version 1.0.0 \
  --changelog "Initial release: Bocha AI Search integration for OpenClaw with Chinese content optimization" \
  --tags "search,chinese,bocha,web,ai-search,news,中文搜索"
```

## 方法三：打包后网页上传

### 1. 创建 zip 文件

```bash
cd /path/to/parent/directory

# 排除不需要的文件
zip -r bocha-search-v1.0.0.zip bocha-search \
  -x "*/node_modules/*" \
  -x "*/.git/*" \
  -x "*/test/*" \
  -x "*.log"
```

### 2. 网页上传

1. 访问 https://clawdhub.com
2. 登录账号
3. 点击 "Publish New Skill" 或 "发布新技能"
4. 填写信息：
   - **Slug**: `bocha-search`
   - **Name**: `Bocha Search`
   - **Version**: `1.0.0`
   - **Description**: `Search the web using Bocha AI Search API - optimized for Chinese content`
   - **Tags**: `search, chinese, bocha, web, ai-search`
5. 上传 `bocha-search-v1.0.0.zip` 文件
6. 提交审核

## 发布信息模板

你可以直接复制以下信息：

**Skill 名称**: Bocha Search

**Slug**: bocha-search

**版本**: 1.0.0

**描述**: 
```
🔍 博查AI搜索 - 专为 OpenClaw 设计的中文搜索引擎

功能特点:
• 针对中文内容优化的搜索结果
• AI智能摘要生成
• 支持网页、图片搜索
• 时间范围筛选 (一天/一周/一月/一年)
• 返回结构化数据，包含标题、URL、摘要、发布时间等

使用方法:
1. 从 https://open.bocha.cn/ 获取 API Key
2. 配置 BOCHA_API_KEY 环境变量
3. 直接使用自然语言搜索，例如:"搜索人工智能最新进展"

需要用户自行提供 Bocha API Key。
```

**标签**: `search, chinese, bocha, web, ai-search, news, 中文搜索`

## 验证发布

发布后可以通过以下方式验证：

```bash
# 搜索你的 skill
clawdhub search bocha

# 查看详情
clawdhub info bocha-search

# 测试安装（在另一个目录）
mkdir test-install && cd test-install
clawdhub install bocha-search
```

## 更新版本

当需要更新时，修改代码后执行：

```bash
cd bocha-search

# 更新版本号（遵循 semver）
# 1.0.0 → 1.0.1 (修复bug)
# 1.0.0 → 1.1.0 (新增功能)
# 1.0.0 → 2.0.0 (不兼容改动)

clawdhub publish . \
  --slug bocha-search \
  --version 1.0.1 \
  --changelog "Fixed XXX bug, improved YYY feature"
```

## 常见问题

### Q: 提示 "Not logged in"
A: 先运行 `clawdhub login` 登录

### Q: 提示 "Skill slug already exists"
A: 该名称已被占用，尝试更换 slug，如 `bocha-search-cn`

### Q: 上传失败
A: 检查：
- SKILL.md 是否存在且格式正确
- 文件是否完整
- 网络连接是否正常

### Q: 如何删除已发布的 skill?
A: 联系 ClawdHub 管理员或使用：
```bash
clawdhub delete bocha-search --yes
```

## 需要帮助?

- 📖 [ClawdHub 文档](https://docs.clawdhub.com)
- 💬 [OpenClaw Discord](https://discord.gg/clawd)
- 🐛 [GitHub Issues](https://github.com/openclaw/openclaw/issues)

---

祝你发布顺利！🎉