# 发布指南 - Bocha Search Skill

本文档介绍如何将 bocha-search skill 发布到 ClawdHub，供其他 OpenClaw 用户使用。

## 📦 发布前准备

### 1. 确保文件完整

检查以下文件是否都存在：

```bash
bocha-search/
├── SKILL.md              # ✅ 技能定义（必需）
├── README.md             # ✅ 使用说明（推荐）
├── LICENSE               # ✅ MIT 许可证（推荐）
├── PUBLISH.md            # ✅ 本文件
└── scripts/              # ✅ 脚本目录
    ├── package.json      # ✅ Node.js 配置
    ├── tool.json         # ✅ 工具定义
    └── bocha_search.js   # ✅ 主脚本
```

### 2. 测试功能

在发布前，确保 skill 能正常工作：

```bash
# 设置 API Key
export BOCHA_API_KEY="sk-a2f0234180684fe0adcf6302c6027040"

# 测试搜索
cd scripts
echo '{"query": "测试", "count": 3}' | node bocha_search.js
```

### 3. 更新版本号

在 `package.json` 中更新版本号：

```json
{
  "name": "bocha-search-tool",
  "version": "1.0.0",  // ← 更新这里
  ...
}
```

## 🚀 发布步骤

### 方法一：使用 ClawdHub CLI（推荐）

#### Step 1: 安装 ClawdHub CLI

```bash
npm install -g clawdhub
```

#### Step 2: 登录 ClawdHub

```bash
clawdhub login
```

这将打开浏览器让你登录。如果无法使用浏览器，可以使用 token：

```bash
clawdhub login --token "your-api-token"
```

#### Step 3: 发布 Skill

进入 skill 目录并发布：

```bash
cd ~/.openclaw/workspace/skills/bocha-search

clawdhub publish . \
  --slug bocha-search \
  --name "Bocha Search" \
  --version 1.0.0 \
  --changelog "Initial release: Bocha AI Search integration for OpenClaw" \
  --tags "search,chinese,bocha,web,ai-search,news"
```

参数说明：
- `--slug`: 唯一标识符，用户将用此名称安装
- `--name`: 显示名称
- `--version`: 遵循语义化版本 (semver)
- `--changelog`: 版本更新说明
- `--tags`: 逗号分隔的标签，帮助用户发现

#### Step 4: 验证发布

发布后，可以在 ClawdHub 上查看：

```bash
# 搜索你的 skill
clawdhub search bocha

# 查看详情
clawdhub info bocha-search
```

### 方法二：手动打包上传

如果不想使用 CLI，可以手动打包：

#### Step 1: 创建压缩包

```bash
cd ~/.openclaw/workspace/skills

# 创建 zip 文件（排除不需要的文件）
zip -r bocha-search-v1.0.0.zip bocha-search \
  -x "*/node_modules/*" \
  -x "*/.git/*" \
  -x "*/test/*"
```

#### Step 2: 上传到 ClawdHub

1. 访问 https://clawdhub.com
2. 登录你的账号
3. 点击 "Publish New Skill"
4. 填写表单并上传 zip 文件
5. 提交审核

## 🔄 更新版本

当需要修复 bug 或添加功能时：

### 1. 修改代码

更新脚本或文档。

### 2. 更新版本号

在 `package.json` 中增加版本号：

```json
{
  "version": "1.0.1"  // 或 1.1.0, 2.0.0 等
}
```

### 3. 发布新版本

```bash
cd ~/.openclaw/workspace/skills/bocha-search

clawdhub publish . \
  --slug bocha-search \
  --version 1.0.1 \
  --changelog "Fixed XXX bug, improved YYY feature"
```

## 📋 最佳实践

### 版本号规范

使用 [语义化版本](https://semver.org/lang/zh-CN/)：

- **MAJOR** (主版本): 不兼容的 API 修改（如 1.0.0 → 2.0.0）
- **MINOR** (次版本): 向下兼容的功能新增（如 1.0.0 → 1.1.0）
- **PATCH** (修订号): 向下兼容的问题修正（如 1.0.0 → 1.0.1）

### Changelog 写法

好的 changelog 示例：

```
v1.0.1 (2026-02-04)
- Fixed: 修复了 API 响应解析错误
- Improved: 优化了中文搜索结果的格式化
- Added: 支持图片结果显示

v1.0.0 (2026-02-03)
- Initial release
- 支持博查AI搜索API
- 支持网页、图片搜索
- 支持时间筛选和摘要生成
```

### 标签选择

选择合适的标签帮助用户发现：

- **必需**: `search` (搜索类)
- **推荐**: `chinese` (中文), `web` (网页)
- **可选**: `news` (新闻), `ai` (AI), `tools` (工具)

## 🔒 安全注意事项

### API Key 处理

- ❌ **永远不要**在代码中硬编码 API key
- ✅ 使用环境变量或配置文件
- ✅ 在文档中明确说明用户需要提供自己的 API key

### 敏感信息检查

发布前检查是否意外包含：

```bash
# 检查是否包含敏感信息
grep -r "sk-" . --include="*.js" --include="*.json" --include="*.md"
grep -r "password" . --include="*.js" --include="*.json"
grep -r "apiKey" . --include="*.js" --include="*.json"
```

## 📊 发布后维护

### 监控使用情况

在 ClawdHub 后台可以查看：
- 安装次数
- 用户评分
- 问题反馈

### 回应用户反馈

- 及时回复 Issues
- 定期更新依赖
- 保持文档最新

### 推广你的 Skill

- 在社交媒体分享
- 在 OpenClaw 社区论坛发帖
- 写博客文章介绍使用方法

## 🆘 常见问题

### Q: 发布失败怎么办？

检查以下几点：
1. 是否已登录 `clawdhub whoami`
2. SKILL.md 是否有正确的 YAML frontmatter
3. 版本号是否符合 semver 规范
4. 文件是否完整

### Q: 如何删除已发布的版本？

联系 ClawdHub 管理员或使用：

```bash
clawdhub delete bocha-search --version 1.0.0 --yes
```

### Q: 可以设置为私有吗？

目前 ClawdHub 只支持公开 skills。如需私有使用，建议：
- 直接分享 git 仓库链接
- 使用本地路径安装

## 📞 获取帮助

- **ClawdHub 文档**: https://docs.clawdhub.com
- **OpenClaw 文档**: https://docs.openclaw.ai/tools/clawdhub
- **社区论坛**: https://discord.gg/clawd
- **GitHub Issues**: https://github.com/openclaw/openclaw/issues

---

祝发布顺利！🎉