#!/bin/bash
# Search for available APIs on the Bob P2P network
# Works on: Ubuntu, macOS, Windows (Git Bash/WSL)

CLIENT_DIR="$HOME/.bob-p2p/client"
CONFIG_FILE="$CLIENT_DIR/config.json"

if [ ! -d "$CLIENT_DIR" ]; then
    echo "❌ Bob P2P client not installed."
    echo ""
    echo "Run setup first:"
    SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
    echo "  bash $SCRIPT_DIR/setup.sh"
    exit 1
fi

if [ ! -f "$CONFIG_FILE" ]; then
    echo "❌ Config file not found at $CONFIG_FILE"
    echo "   Run setup.sh to create configuration."
    exit 1
fi

cd "$CLIENT_DIR"
node src/cli/consumer-search.js --config config.json "$@"
