#!/bin/bash
# Check status of a job
# Works on: Ubuntu, macOS, Windows (Git Bash/WSL)

CLIENT_DIR="$HOME/.bob-p2p/client"
CONFIG_FILE="$CLIENT_DIR/config.json"

if [ ! -d "$CLIENT_DIR" ]; then
    echo "❌ Bob P2P client not installed."
    SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
    echo "   Run: bash $SCRIPT_DIR/setup.sh"
    exit 1
fi

if [ -z "$1" ]; then
    echo "Usage: bash scripts/job-status.sh <job-id> --provider <url>"
    echo ""
    echo "Example:"
    echo "  bash scripts/job-status.sh job-123456 --provider http://localhost:8000"
    exit 1
fi

cd "$CLIENT_DIR"
node src/cli/consumer-job.js "$1" --config config.json "${@:2}"
