#!/bin/bash
# Get detailed info about a specific API
# Works on: Ubuntu, macOS, Windows (Git Bash/WSL)

CLIENT_DIR="$HOME/.bob-p2p/client"
CONFIG_FILE="$CLIENT_DIR/config.json"

if [ -z "$1" ]; then
    echo "Usage: bash scripts/api-info.sh <api-id>"
    echo ""
    echo "Example: bash scripts/api-info.sh runware-text-to-image-v1"
    exit 1
fi

API_ID="$1"

# Get aggregator URL from config
if [ -f "$CONFIG_FILE" ]; then
    AGGREGATOR=$(grep -o '"http[^"]*"' "$CONFIG_FILE" | head -1 | tr -d '"')
fi
AGGREGATOR="${AGGREGATOR:-http://localhost:8080}"

echo "🔍 Fetching info for API: $API_ID"
echo "   Aggregator: $AGGREGATOR"
echo ""

# Fetch and pretty-print
RESULT=$(curl -s "$AGGREGATOR/api/$API_ID")

# Try python, then node, then raw output
if command -v python3 &> /dev/null; then
    echo "$RESULT" | python3 -m json.tool 2>/dev/null || echo "$RESULT"
elif command -v python &> /dev/null; then
    echo "$RESULT" | python -m json.tool 2>/dev/null || echo "$RESULT"
elif command -v node &> /dev/null; then
    echo "$RESULT" | node -e "let d='';process.stdin.on('data',c=>d+=c);process.stdin.on('end',()=>console.log(JSON.stringify(JSON.parse(d),null,2)))" 2>/dev/null || echo "$RESULT"
else
    echo "$RESULT"
fi

echo ""
