/**
 * Helper utilities
 */

const crypto = require('crypto');

/**
 * Generate a unique queue code
 */
function generateQueueCode() {
    return crypto.randomBytes(16).toString('hex');
}

/**
 * Generate a unique job ID
 */
function generateJobId() {
    return `job-${Date.now()}-${crypto.randomBytes(8).toString('hex')}`;
}

/**
 * Sleep for specified milliseconds
 */
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

/**
 * Format token amount for display
 */
function formatAmount(amount, symbol = 'BOB') {
    return `${amount.toFixed(4)} ${symbol}`;
}

/**
 * Format timestamp for display
 */
function formatTimestamp(timestamp) {
    return new Date(timestamp).toISOString();
}

/**
 * Calculate expiry timestamp
 */
function calculateExpiry(seconds) {
    return Date.now() + (seconds * 1000);
}

/**
 * Check if timestamp is expired
 */
function isExpired(timestamp) {
    return Date.now() > timestamp;
}

module.exports = {
    generateQueueCode,
    generateJobId,
    sleep,
    formatAmount,
    formatTimestamp,
    calculateExpiry,
    isExpired
};
