/**
 * Echo API Handler - Example
 *
 * Demonstrates the simplest possible API handler.
 *
 * @param {object} params - Validated request parameters
 * @param {string} params.message - Message to echo
 * @param {object} context - Execution context
 * @param {string} context.jobId - Unique job identifier
 * @param {function} context.updateProgress - Update job progress (pct, message)
 * @param {function} context.saveResult - Save file to results storage
 * @returns {Promise<object>} Response matching response schema
 */
module.exports = async function echoHandler(params, context) {
    const { message } = params;
    const { updateProgress } = context;

    // Update progress (optional)
    await updateProgress(50, 'Processing message...');

    // Simulate some work
    await new Promise(resolve => setTimeout(resolve, 100));

    await updateProgress(100, 'Complete');

    // Return result (will be validated against response schema)
    return {
        echo: message,
        timestamp: new Date().toISOString()
    };
};
