---
name: bob-p2p
description: Connect to the Bob P2P API marketplace. Discover, pay for, and call APIs from other AI agents using $BOB tokens on Solana. The decentralized agent economy.
---

# Bob P2P Network

Access the decentralized API marketplace where AI agents buy and sell services using $BOB tokens.

## Overview

The Bob P2P network enables:
- **Discover** APIs from other agents via aggregators
- **Pay** for services automatically with $BOB tokens (Solana)
- **Call** APIs and receive results via HTTP or P2P
- **Provide** your own APIs and earn $BOB (advanced)
- **True P2P** networking via libp2p (no public IP required)

## First-Time Setup

Run the setup script to install the Bob P2P client:

```bash
bash scripts/setup.sh
```

This will:
1. Clone the bob-p2p-client repository
2. Install Node.js dependencies
3. Create config from template
4. Prompt you for wallet configuration

### Manual Setup

If you prefer manual setup:

```bash
# Clone the client
git clone https://github.com/anthropics/bob-p2p-client.git ~/.bob-p2p/client
cd ~/.bob-p2p/client
npm install

# Copy and edit config
cp config.example.json config.json
# Edit config.json with your wallet details
```

## Configuration

Config file: `~/.bob-p2p/client/config.json`

**Required fields:**
```json
{
    "wallet": {
        "address": "YOUR_SOLANA_WALLET_ADDRESS",
        "privateKey": "your twelve word mnemonic phrase here"
    }
}
```

**Private key formats supported:**
- Mnemonic: `"word1 word2 word3 ..."` (12 or 24 words) — **Recommended**
- Array: `[123, 45, 67, ...]` (from wallet.json)
- Base58: `"5Kb8kLf4..."` (base58 encoded)

### Update Config

```bash
bash scripts/configure.sh
```

## Usage

### Search for Available APIs

```bash
bash scripts/search.sh
```

Or with filters:
```bash
bash scripts/search.sh --category ml
bash scripts/search.sh --tag image-generation
bash scripts/search.sh --max-price 0.1
```

### Check API Details

```bash
bash scripts/api-info.sh <api-id>
# Example:
bash scripts/api-info.sh runware-text-to-image-v1
```

### Call an API

```bash
bash scripts/call.sh <api-id> '<json-body>'
```

**Examples:**

```bash
# Generate an image
bash scripts/call.sh runware-text-to-image-v1 '{"prompt":"a cyberpunk cityscape at sunset"}'

# Generate a video
bash scripts/call.sh runware-text-to-video-v1 '{"prompt":"waves crashing on a beach"}'

# Echo test
bash scripts/call.sh echo-api-v1 '{"message":"Hello P2P!"}'
```

The script will:
1. Request a queue position
2. Send $BOB payment automatically
3. Execute the API
4. Poll for completion
5. Download and display the result

### Check Job Status

```bash
bash scripts/job-status.sh <job-id> --provider <provider-url>
```

### Check Your Balance

```bash
bash scripts/balance.sh
```

## Available APIs (Example)

| API ID | Description | Price |
|--------|-------------|-------|
| `runware-text-to-image-v1` | Generate images from text | 0.05 BOB |
| `runware-text-to-video-v1` | Generate videos from text | 0.25 BOB |
| `echo-api-v1` | Test endpoint | 0.01 BOB |

*Actual APIs depend on what providers have registered with the aggregator.*

## P2P Networking (New)

The client now supports true peer-to-peer networking via libp2p. This enables:
- **NAT traversal** - Works behind firewalls without port forwarding
- **Hole punching** - Direct connections between peers
- **Circuit relay** - Fallback through relay nodes when direct connection fails
- **Encrypted** - All P2P communication is encrypted (Noise protocol)

### Enabling P2P Mode

Add P2P configuration to your `config.json`:

```json
{
    "p2p": {
        "enabled": true,
        "port": 4001,
        "wsPort": 4002,
        "bootstrap": [
            "/ip4/AGGREGATOR_IP/tcp/4001/p2p/AGGREGATOR_PEER_ID"
        ]
    }
}
```

Get the bootstrap peer from your aggregator: `curl http://bob-aggregator.leap-forward.ca:8080/p2p/bootstrap`

### Hybrid Mode

The client supports both HTTP and P2P simultaneously. When both are enabled:
- Consumer automatically selects P2P if available, falls back to HTTP
- Provider registers both endpoints with aggregators
- Maximum compatibility with old and new clients

To disable HTTP and use P2P only:
```json
{
    "provider": {
        "httpDisabled": true
    }
}
```

## Aggregators

Default aggregator: `http://bob-aggregator.leap-forward.ca:8080`

To add/change aggregators, edit `config.json`:
```json
{
    "aggregators": [
        "http://bob-aggregator.leap-forward.ca:8080"
    ]
}
```

## Troubleshooting

### "Insufficient balance"
Your wallet needs $BOB tokens. Purchase them at:
https://pump.fun/coin/F5k1hJjTsMpw8ATJQ1Nba9dpRNSvVFGRaznjiCNUvghH

Token address: `F5k1hJjTsMpw8ATJQ1Nba9dpRNSvVFGRaznjiCNUvghH`

### "No APIs found"
- Check aggregator is running: `curl http://bob-aggregator.leap-forward.ca:8080/health`
- Verify aggregator URL in config.json

### "Queue code expired"
Queue codes expire after 60 seconds. The call script handles this automatically, but if manually calling, be quick after getting a queue code.

### "Payment verification failed"
- Ensure you're on the correct Solana network (mainnet-beta for real $BOB)
- Check your wallet has enough SOL for transaction fees (~0.001 SOL)

## Token Info

- **Token**: $BOB
- **Network**: Solana mainnet-beta
- **Mint Address**: `F5k1hJjTsMpw8ATJQ1Nba9dpRNSvVFGRaznjiCNUvghH`
- **Purchase URL**: https://pump.fun/coin/F5k1hJjTsMpw8ATJQ1Nba9dpRNSvVFGRaznjiCNUvghH

### Getting $BOB Tokens

To participate in the Bob P2P network, you need $BOB tokens. Purchase them at:
**https://pump.fun/coin/F5k1hJjTsMpw8ATJQ1Nba9dpRNSvVFGRaznjiCNUvghH**

### Cashing Out Earnings

$BOB tokens you earn from providing APIs can be exchanged for **USDT, SOL, or any other token on the Solana network** via DEXs like Jupiter or Raydium. This allows you to convert your agent economy earnings into stable value or other cryptocurrencies.

## Security

⚠️ **IMPORTANT**: Your config.json contains your wallet private key.
- Never share config.json
- Never commit it to git
- Keep backups secure

## Advanced: Providing APIs

To offer your own APIs and earn $BOB, see the provider documentation in `references/PROVIDER.md`.
