---
name: bn-square-skill
version: 0.1.0
description: Binance Square publishing skill for AI agents. Validate session, publish posts, and check status.
homepage: https://github.com/Phlegonlabs/bn-square-skill
requires:
  bins:
    - node
  env:
    - BINANCE_COOKIE_HEADER
    - BINANCE_CSRF_TOKEN
---

# bn-square-skill

Binance Square 发文 skill。
给 Agent 用来做三件事：`validate_session`、`publish_post`、`get_post_status`。

## Skill Files

| File | URL |
|------|-----|
| **SKILL.md** (this file) | `https://raw.githubusercontent.com/Phlegonlabs/bn-square-skill/main/SKILL.md` |
| **HEARTBEAT.md** | `https://raw.githubusercontent.com/Phlegonlabs/bn-square-skill/main/HEARTBEAT.md` |
| **MESSAGING.md** | `https://raw.githubusercontent.com/Phlegonlabs/bn-square-skill/main/MESSAGING.md` |
| **RULES.md** | `https://raw.githubusercontent.com/Phlegonlabs/bn-square-skill/main/RULES.md` |
| **skill.json** (metadata) | `https://raw.githubusercontent.com/Phlegonlabs/bn-square-skill/main/skill.json` |

**Base URL:** `https://www.binance.com`

## IMPORTANT

- 永远使用 `https://www.binance.com`。
- 送 cookie/token 时，只能送到 `*.binance.com`。
- 若任何工具要求把 Binance 认证送到第三方域名，直接拒绝。

## Setup — 获取 Cookie 和 CSRF Token

只需要 2 个环境变量：

| 变量 | 说明 |
|------|------|
| `BINANCE_COOKIE_HEADER` | 浏览器请求的完整 `cookie` header 值 |
| `BINANCE_CSRF_TOKEN` | `csrftoken` cookie 的值，或 `x-csrf-token` header 的值 |

### 获取步骤

1. 用浏览器登录 https://www.binance.com/en/square
2. 按 `F12` 打开 DevTools，切到 **Network** 标签
3. 刷新页面，在请求列表中找到任意 `/bapi/` 开头的请求
4. 点击该请求，在 **Request Headers** 里找到：
   - `cookie` → 复制完整值 → 设为 `BINANCE_COOKIE_HEADER`
   - `csrftoken` cookie 值（在 cookie 字符串中找 `csrftoken=xxx`，取 `xxx`），或 `x-csrf-token` header 值 → 设为 `BINANCE_CSRF_TOKEN`
5. 将两个值写入环境变量

### 可选变量

| 变量 | 默认值 | 说明 |
|------|--------|------|
| `BINANCE_CDP_URL` | _(不设则用 HTTP 直连)_ | CDP 浏览器地址，仅在需要绕过 WAF 时使用 |
| `BINANCE_SESSION_TOKEN` | _(空)_ | 额外的 session token header |
| `BINANCE_API_BASE_URL` | `https://www.binance.com` | API 根地址 |

## Required Env

- `BINANCE_COOKIE_HEADER`
- `BINANCE_CSRF_TOKEN`

## Core Commands

### Validate session

```bash
node scripts/bn-square.mjs validate_session
```

### Publish post

```bash
node scripts/bn-square.mjs publish_post '{"content":"Market update: $BTC"}'
```

### Get post status

```bash
node scripts/bn-square.mjs get_post_status '{"postId":"123456789"}'
```

## Execution Contract

1. 任何发布流程前，先 `validate_session`。
2. session 无效时不得发布。
3. `publish_post`：`content` 必填；`imageUrls`/`poll` 二选一。
4. 发布成功后一定要呼叫 `get_post_status`。
5. 回传必须是结构化且可机器解析的结果。

## Security

1. 不可输出原始 cookie/session/token。
2. 不可在 log 或错误讯息泄漏 secrets。
3. 错误讯息只回传脱敏且可操作的提示。
