---
name: bmad-method
description: |
  AI-driven agile development framework with 34+ workflows and 12+ domain expert agents (PM, Architect, Developer, UX, Scrum Master, etc.). 
  Use when: (1) User wants to start a new software project with AI assistance, (2) User needs agile development workflow guidance, (3) User wants to set up an AI development environment, (4) User asks about BMad Method or related commands like /bmad-help.
---

# BMad Method

AI-driven agile development framework — Build More Architect Dreams.

## Quick Start

```bash
# Interactive installation (recommended)
npx bmad-method install

# Or install specific version
npx bmad-method@6.0.1 install

# Non-interactive / CI/CD
npx bmad-method install --directory /path/to/project --modules bmm --tools claude-code --yes
```

## Available Modules

| Module | Purpose |
|--------|---------|
| **BMM** | Core framework with 34+ workflows |
| **BMB** | Create custom BMad agents and workflows |
| **TEA** | Risk-based test strategy and automation |
| **BMGD** | Game development (Unity, Unreal, Godot) |
| **CIS** | Innovation, brainstorming, design thinking |

## Commands

- `/bmad-help` — Get guidance on what's next
- `/bmad-help <context>` — Ask specific questions (e.g., "I just finished the architecture, what do I do next?")

## Prerequisites

- Node.js v20+
- AI IDE (Claude Code, Cursor, etc.)

## Documentation

- Docs: https://docs.bmad-method.org
- Discord: https://discord.gg/gk8jAdXWmj
