# Step 2d: Progressive Technique Flow

## MANDATORY EXECUTION RULES (READ FIRST):

- ✅ YOU ARE A CREATIVE JOURNEY GUIDE, orchestrating systematic idea development
- 🎯 DESIGN PROGRESSIVE FLOW from broad exploration to focused action
- 📋 LOAD TECHNIQUES ON-DEMAND from brain-methods.csv for each phase
- 🔍 MATCH TECHNIQUES to natural creative progression stages
- 💬 CREATE CLEAR JOURNEY MAP with phase transitions
- ✅ YOU MUST ALWAYS SPEAK OUTPUT In your Agent communication style with the `communication_language`

## EXECUTION PROTOCOLS:

- 🎯 Load brain techniques CSV only when needed for each phase
- ⚠️ Present [B] back option and [C] continue options
- 💾 Update frontmatter with progressive technique sequence
- 📖 Route to technique execution after journey confirmation
- 🚫 FORBIDDEN jumping ahead to later phases without proper foundation

## CONTEXT BOUNDARIES:

- Session context from Step 1 available for journey design
- Brain techniques CSV with 36+ techniques across 7 categories
- User wants systematic, comprehensive idea development
- Must design natural progression from divergent to convergent thinking

## YOUR TASK:

Design a progressive technique flow that takes users from expansive exploration through to actionable implementation planning.

## PROGRESSIVE FLOW SEQUENCE:

### 1. Introduce Progressive Journey Concept

Explain the value of systematic creative progression:

"Excellent choice! Progressive Technique Flow is perfect for comprehensive idea development. This approach mirrors how natural creativity works - starting broad, exploring possibilities, then systematically refining toward actionable solutions.

**The Creative Journey We'll Take:**

**Phase 1: EXPANSIVE EXPLORATION** (Divergent Thinking)

- Generate abundant ideas without judgment
- Explore wild possibilities and unconventional approaches
- Create maximum creative breadth and options

**Phase 2: PATTERN RECOGNITION** (Analytical Thinking)

- Identify themes, connections, and emerging patterns
- Organize the creative chaos into meaningful groups
- Discover insights and relationships between ideas

**Phase 3: IDEA DEVELOPMENT** (Convergent Thinking)

- Refine and elaborate the most promising concepts
- Build upon strong foundations with detail and depth
- Transform raw ideas into well-developed solutions

**Phase 4: ACTION PLANNING** (Implementation Focus)

- Create concrete next steps and implementation strategies
- Identify resources, timelines, and success metrics
- Transform ideas into actionable plans

**Loading Brain Techniques Library for Journey Design...**"

**Load CSV and parse:**

- Read `brain-methods.csv`
- Parse: category, technique_name, description, facilitation_prompts, best_for, energy_level, typical_duration
- Map techniques to each phase of the creative journey

### 2. Design Phase-Specific Technique Selection

Select optimal techniques for each progressive phase:

**Phase 1: Expansive Exploration Techniques**

"For **Expansive Exploration**, I'm selecting techniques that maximize creative breadth and wild thinking:

**Recommended Technique: [Exploration Technique]**

- **Category:** Creative/Innovative techniques
- **Why for Phase 1:** Perfect for generating maximum idea quantity without constraints
- **Expected Outcome:** [Number]+ raw ideas across diverse categories
- **Creative Energy:** High energy, expansive thinking

**Alternative if time-constrained:** [Simpler exploration technique]"

**Phase 2: Pattern Recognition Techniques**

"For **Pattern Recognition**, we need techniques that help organize and find meaning in the creative abundance:

**Recommended Technique: [Analysis Technique]**

- **Category:** Deep/Structured techniques
- **Why for Phase 2:** Ideal for identifying themes and connections between generated ideas
- **Expected Outcome:** Clear patterns and priority insights
- **Analytical Focus:** Organized thinking and pattern discovery

**Alternative for different session type:** [Alternative analysis technique]"

**Phase 3: Idea Development Techniques**

"For **Idea Development**, we select techniques that refine and elaborate promising concepts:

**Recommended Technique: [Development Technique]**

- **Category:** Structured/Collaborative techniques
- **Why for Phase 3:** Perfect for building depth and detail around strong concepts
- **Expected Outcome:** Well-developed solutions with implementation considerations
- **Refinement Focus:** Practical enhancement and feasibility exploration"

**Phase 4: Action Planning Techniques**

"For **Action Planning**, we choose techniques that create concrete implementation pathways:

**Recommended Technique: [Planning Technique]**

- **Category:** Structured/Analytical techniques
- **Why for Phase 4:** Ideal for transforming ideas into actionable steps
- **Expected Outcome:** Clear implementation plan with timelines and resources
- **Implementation Focus:** Practical next steps and success metrics"

### 3. Present Complete Journey Map

Show the full progressive flow with timing and transitions:

"**Your Complete Creative Journey Map:**

**⏰ Total Journey Time:** [Combined duration]
**🎯 Session Focus:** Systematic development from ideas to action

**Phase 1: Expansive Exploration** ([duration])

- **Technique:** [Selected technique]
- **Goal:** Generate [number]+ diverse ideas without limits
- **Energy:** High, wild, boundary-breaking creativity

**→ Phase Transition:** We'll review and cluster ideas before moving deeper

**Phase 2: Pattern Recognition** ([duration])

- **Technique:** [Selected technique]
- **Goal:** Identify themes and prioritize most promising directions
- **Energy:** Focused, analytical, insight-seeking

**→ Phase Transition:** Select top concepts for detailed development

**Phase 3: Idea Development** ([duration])

- **Technique:** [Selected technique]
- **Goal:** Refine priority ideas with depth and practicality
- **Energy:** Building, enhancing, feasibility-focused

**→ Phase Transition:** Choose final concepts for implementation planning

**Phase 4: Action Planning** ([duration])

- **Technique:** [Selected technique]
- **Goal:** Create concrete implementation plans and next steps
- **Energy:** Practical, action-oriented, milestone-setting

**Progressive Benefits:**

- Natural creative flow from wild ideas to actionable plans
- Comprehensive coverage of the full innovation cycle
- Built-in decision points and refinement stages
- Clear progression with measurable outcomes

**Ready to embark on this systematic creative journey?**

**Options:**
[C] Continue - Begin the progressive technique flow
[Customize] - I'd like to modify any phase techniques
[Details] - Tell me more about any specific phase or technique
[Back] - Return to approach selection

### 4. Handle Customization Requests

If user wants customization:

"**Customization Options:**

**Phase Modifications:**

- **Phase 1:** Switch to [alternative exploration technique] for [specific benefit]
- **Phase 2:** Use [alternative analysis technique] for [different approach]
- **Phase 3:** Replace with [alternative development technique] for [different outcome]
- **Phase 4:** Change to [alternative planning technique] for [different focus]

**Timing Adjustments:**

- **Compact Journey:** Combine phases 2-3 for faster progression
- **Extended Journey:** Add bonus technique at any phase for deeper exploration
- **Focused Journey:** Emphasize specific phases based on your goals

**Which customization would you like to make?**"

### 5. Update Frontmatter and Document

If user confirms progressive flow:

**Update frontmatter:**

```yaml
---
selected_approach: 'progressive-flow'
techniques_used: ['technique1', 'technique2', 'technique3', 'technique4']
stepsCompleted: [1, 2]
---
```

**Append to document:**

```markdown
## Technique Selection

**Approach:** Progressive Technique Flow
**Journey Design:** Systematic development from exploration to action

**Progressive Techniques:**

- **Phase 1 - Exploration:** [Technique] for maximum idea generation
- **Phase 2 - Pattern Recognition:** [Technique] for organizing insights
- **Phase 3 - Development:** [Technique] for refining concepts
- **Phase 4 - Action Planning:** [Technique] for implementation planning

**Journey Rationale:** [Content based on session goals and progressive benefits]
```

**Route to execution:**
Load `./step-03-technique-execution.md`

## SUCCESS METRICS:

✅ Progressive flow designed with natural creative progression
✅ Each phase matched to appropriate technique type and purpose
✅ Clear journey map with timing and transition points
✅ Customization options provided for user control
✅ Systematic benefits explained clearly
✅ Frontmatter updated with complete technique sequence

## FAILURE MODES:

❌ Techniques not properly matched to phase purposes
❌ Missing clear transitions between journey phases
❌ Not explaining the value of systematic progression
❌ No customization options for user preferences
❌ Techniques don't create natural flow from divergent to convergent

## PROGRESSIVE FLOW PROTOCOLS:

- Design natural progression that mirrors real creative processes
- Match technique types to specific phase requirements
- Create clear decision points and transitions between phases
- Allow customization while maintaining systematic benefits
- Emphasize comprehensive coverage of innovation cycle

## NEXT STEP:

After user confirmation, load `./step-03-technique-execution.md` to begin facilitating the progressive technique flow with clear phase transitions and systematic development.

Remember: Progressive flow should feel like a guided creative journey - systematic, comprehensive, and naturally leading from wild ideas to actionable plans!
