# 🦋 Bluesky CLI

[![Version](https://img.shields.io/badge/version-1.6.0-blue.svg)](https://github.com/jeffaf/bluesky-skill)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![Python](https://img.shields.io/badge/python-3.8+-yellow.svg)](https://python.org)

A full-featured command-line interface for [Bluesky](https://bsky.app) (AT Protocol). Post, reply, like, repost, follow, block, mute, search — everything you need to engage on Bluesky from your terminal.

**Built for [OpenClaw](https://github.com/openclaw/openclaw)** — works standalone too.

## ✨ Features

| Category | Commands |
|----------|----------|
| **Content** | `post`, `reply`, `quote`, `delete` |
| **Engagement** | `like`, `unlike`, `repost`, `unrepost` |
| **Social** | `follow`, `unfollow`, `profile` |
| **Moderation** | `block`, `unblock`, `mute`, `unmute` |
| **Discovery** | `timeline`, `search`, `notifications`, `thread` |
| **Threading** | `create-thread` — post multi-part threads |
| **Media** | Image attachments with alt text |

**Plus:** JSON output on all read commands, dry-run mode, auto-linked URLs and @mentions.

## 🚀 Quick Start

### Step 1: Get an App Password from Bluesky

1. Open [bsky.app](https://bsky.app) and log in
2. Click your avatar → **Settings**
3. Go to **Privacy and Security** → **App Passwords**
4. Click **Add App Password**
5. Name it something like "CLI" or "OpenClaw"
6. Copy the password (looks like `xxxx-xxxx-xxxx-xxxx`)

> ⚠️ **Save this password somewhere safe** — Bluesky only shows it once!

### Step 2: Login via CLI

Tell your OpenClaw agent:
> "Log me into Bluesky. My handle is `yourname.bsky.social` and my app password is `xxxx-xxxx-xxxx-xxxx`"

Or run directly:
```bash
bsky login --handle yourname.bsky.social --password xxxx-xxxx-xxxx-xxxx
```

**Your password is used once to get a session token, then immediately discarded. It's never stored.**

### Step 3: Verify & Start Posting

```bash
bsky whoami                              # Confirm you're logged in
bsky post "Hello from the command line! 🦋"  # Your first post!
```

## 📖 Usage

### Posting & Content

```bash
bsky post "Hello world!"                              # Simple post
bsky post "Look!" --image pic.jpg --alt "A sunset"    # With image
bsky reply <url> "Great point!"                       # Reply
bsky quote <url> "This is important"                  # Quote-post
bsky delete <url>                                     # Delete your post
```

### Engagement

```bash
bsky like <url>          # ❤️ Like a post
bsky unlike <url>        # Remove like
bsky repost <url>        # 🔁 Boost (aliases: boost, rt)
bsky unrepost <url>      # Remove repost
```

### Social

```bash
bsky follow @someone.bsky.social    # Follow
bsky unfollow @someone              # Unfollow
bsky profile @someone               # View profile
```

### Moderation

```bash
bsky block @troll.bsky.social       # 🚫 Block
bsky unblock @someone               # Unblock
bsky mute @noisy.bsky.social        # 🔇 Mute
bsky unmute @someone                # Unmute
```

### Threading

```bash
bsky create-thread "First post" "Second post" "Third post"   # Create a thread
bsky ct "Post 1" "Post 2" "Post 3"                           # Short alias
bsky create-thread "Intro" "Details" --dry-run                # Preview only
bsky create-thread "Look!" "More" --image pic.jpg --alt "Photo"  # Image on first post
```

### Discovery

```bash
bsky timeline                       # Your home feed
bsky timeline -n 30                 # More posts
bsky search "topic"                 # Search posts
bsky notifications                  # Your notifications
bsky thread <url>                   # View conversation
```

### JSON Output

Add `--json` to any read command for structured output:

```bash
bsky timeline --json | jq '.[0].text'
bsky search "AI" --json
bsky notifications --json
```

## 🔒 Security

- **Password never stored** — used once to get a session token, then discarded
- **Session tokens auto-refresh** — no need to re-login
- **Config file permissions** — 600 (owner-only read/write)
- **Location:** `~/.config/bsky/config.json`

## 📦 Installation

### For OpenClaw

```bash
clawhub install bluesky
```

### Manual

```bash
git clone https://github.com/jeffaf/bluesky-skill.git ~/clawd/skills/bluesky
cd ~/clawd/skills/bluesky/scripts
./bsky --version  # Auto-creates venv on first run
```

### Requirements

- Python 3.8+
- `atproto` package (installed automatically on first run via venv)

## 🎯 Tips

- **Handles:** Auto-appends `.bsky.social` if no domain specified
- **URLs:** Both `https://bsky.app/...` and `at://` URIs work
- **Dry run:** Use `--dry-run` on post/reply/quote to preview
- **Images:** Max 1MB, alt text required (accessibility)

## 📝 Changelog

See [CHANGELOG.md](CHANGELOG.md) for version history.

## 📄 License

MIT — do whatever you want with it.

---

Made with 🦞 by [jeffaf](https://github.com/jeffaf) and [Mai](https://github.com/openclaw/openclaw)
