# Give Spotlight on Mac Superpowers with Raycast

## What is Raycast?

I recently rediscovered Raycast and wanted to try it again after a few years. Raycast has infinitely more features than Spotlight (Apple's search tool). 

I was skeptical, assuming it would be just another Spotlight replacement that would require a lot of effort for minimal productivity gains, so I was hesitant to give it a try thinking I'd need to devote time and resources I don't have to a steep learning curve. Boy was I wrong!

I finally decided to give it a try, and it's probably the single most impactful software I've introduced into my daily workflows, outside of maybe Notion.

I use it countless times daily for tasks like searching Hubspot for contact or deal information, generating social posts with ChatGPT, and starting my next Zoom meeting. Tasks that would have taken at least a minute or two now take under 10 seconds.

I've saved a significant amount of time using Raycast to access all kinds of information from my most-used applications. The real kicker is that Raycast is a completely **free** application and not a "free plan" with the all the good features paywalled. It's a no-brainer for anyone who frequently uses Spotlight, keyboard shortcuts, or those built into MacOS.

### The Raycast Extension Store

Raycast's Extension Store is a comprehensive directory that's divided into three main categories: productivity, utility, and business. The store houses thousands of extensions that can be installed by simply tapping return.

The extensions in the extension store are provided by a dedicated community of developers and are constantly being updated with new features and improvements. There are thousands of extensions available for the most popular apps and tools out there. A few notable options include Salesforce, Hubspot, ChatGPT, Slack, Notion, Crunchbase, Google Drive/Meet/Calendar/Search, Facetime, Mail, WhatsApp, Todoist, ClickUp, and so many more.

### Interacting with Applications

Since discovering Raycast a few weeks ago, I've been incredibly impressed with its capabilities.

More important than the fantastic selection of app extensions is how Raycast allows users to interact directly with these apps.

Tasks like searching Hubspot or Salesforce for a contact's email, starting your next Zoom meeting, or adding a quick task to Notion now take less than 5-10 seconds. For example, instead of going into Hubspot and finding a contact's profile to grab an email or phone number, I can hit ⌘+space, type "hub," and search my entire Hubspot database right from the command bar.

### Conclusion

It's still hard to believe, but Raycast is completely 100% free. This isn't a "free plan" with all the good features paywalled, but all features are free.

Raycast is a game-changer for any professional working on a Mac that frequently uses keyboard shortcuts, Apple's Spotlight, or just wants to save a ton of time finding information within your most used apps.
