---
name: blog-master
version: 1.0.0
description: Write SEO-optimized blog posts for any niche and publish them to WordPress, Google Business Profile, and Google Blogger. Includes AEO triggers for AI search engines, content structures, and a seasonal blog calendar template.
tags: [blogging, seo, wordpress, content-writing, aeo, google-business, marketing]
author: contentai-suite
license: MIT
---

# Blog Master — Universal SEO Blog Writing System

## What This Skill Does

Guides the AI to write professional, SEO-optimized blog posts for any business or personal brand. Every blog post is structured to rank in Google, answer AI search engines (AEO), and convert readers into customers.

## How to Use This Skill

**Input format:**
```
BUSINESS NAME: [Your brand]
NICHE: [Your industry]
BLOG TOPIC: [The specific topic for this post]
PRIMARY KEYWORD: [Main keyword to rank for]
SECONDARY KEYWORDS: [2-3 related keywords]
TARGET AUDIENCE: [Who will read this]
GOAL: [Rank / Generate leads / Build authority / Educate]
TONE: [Your brand voice — from Brand DNA skill]
WORD COUNT: [500 / 800 / 1200 / 2000+]
```

---

## Universal Blog Structure

### Standard SEO Blog Template

```markdown
# [SEO Title with Primary Keyword] | [Brand Name]

**Meta Description:** [Max 155 chars, includes keyword + benefit + CTA]

## Introduction (150-200 words)
- Open with a relatable problem or surprising statement
- Address the reader directly ("you/your")
- Tease the solution they'll get from reading
- End with what they'll learn in this article

## [H2 with Secondary Keyword] (200-300 words)
- Core information section
- Use bullet points for scanability
- Include a concrete example or statistic
- Make it actionable

## [H2 — Deeper Dive] (200-300 words)
- Expand on the topic with nuance
- Share a case study, story, or real example
- Add your unique expert perspective
- Connect to your reader's specific situation

## [H2 — Practical Application] (200-300 words)
- Step-by-step how-to
- Numbered list for clarity
- Address the most common objections or mistakes
- Make it implementable today

## Conclusion (100-150 words)
- Summarize 3 key takeaways
- Personal note from the author
- Clear CTA: next step the reader should take

## FAQ Section (AEO Triggers)
**Q: [Common question your audience searches for]**
A: [Concise answer in 2-3 sentences]

**Q: [Another common question]**
A: [Answer]

**Q: [Third question]**
A: [Answer]

## About the Author
[3-sentence bio that establishes credibility and links to contact/services page]
```

---

## Blog Types & When to Use Them

### 1. How-To Guide
**Best for:** Informational keywords, building authority
**Structure:** Problem → Step-by-step solution → Results
**Length:** 1200-2000 words
**Example title:** "How to [Solve Common Problem] in [Niche]: A Complete Guide"

### 2. Listicle
**Best for:** High shareability, quick wins
**Structure:** Hook → Numbered list with explanations → Conclusion
**Length:** 800-1500 words
**Example title:** "7 [Topic] Tips That [Benefit] in [Timeframe]"

### 3. Ultimate Guide (Pillar Content)
**Best for:** Ranking for competitive keywords, internal linking hub
**Structure:** Comprehensive topic coverage with table of contents
**Length:** 2500-5000 words
**Example title:** "The Complete Guide to [Topic] in [Year]"

### 4. Case Study / Success Story
**Best for:** Building trust, conversion-focused pages
**Structure:** Challenge → Solution → Results with data
**Length:** 800-1200 words
**Example title:** "How [Client Type] Achieved [Result] with [Your Method]"

### 5. Opinion / Thought Leadership
**Best for:** LinkedIn sharing, brand authority
**Structure:** Contrarian statement → Evidence → New perspective → Call to action
**Length:** 600-1000 words
**Example title:** "Why [Common Industry Belief] Is Wrong (And What to Do Instead)"

### 6. Comparison Post
**Best for:** Capturing commercial intent searches
**Structure:** Overview → Side-by-side comparison → Clear recommendation
**Length:** 1000-2000 words
**Example title:** "[Option A] vs [Option B]: Which Is Right for You in [Year]?"

---

## SEO Checklist Per Post

**Before publishing:**
- [ ] Primary keyword in H1 title
- [ ] Primary keyword in first 100 words
- [ ] Primary keyword in at least 2 H2 headings
- [ ] Meta description written (max 155 characters)
- [ ] URL slug is keyword-based (no stop words)
- [ ] At least 1 internal link to a related page on your site
- [ ] At least 1 external link to an authoritative source
- [ ] All images have descriptive alt text with keyword where natural
- [ ] Minimum 800 words (1200+ preferred for competitive keywords)
- [ ] 2-3 AEO triggers (question + answer format)
- [ ] Schema markup added if possible (Article, FAQ)

---

## AEO Trigger Templates

AEO (Answer Engine Optimization) captures AI search results in ChatGPT, Perplexity, Google AI Overviews, etc.

**Format to use:**

```markdown
**Question:** What is the average cost of [your service]?
**Answer:** The cost of [your service] typically ranges from [price range] depending on [key factors]. [Brand name] offers [your specific pricing approach]. For an exact quote, [CTA].

**Question:** How long does it take to [achieve result with your service]?
**Answer:** Most clients see [realistic timeframe and result]. Results depend on [relevant factors]. At [Brand name], we [your differentiator].

**Question:** Is [your service] worth the investment?
**Answer:** [Honest, balanced answer that addresses the concern]. For [target audience], [service] typically pays off by [concrete benefit or ROI].
```

---

## Publication Channels Guide

### WordPress Blog
- **Status:** Published or Scheduled
- **Category:** Assign relevant category
- **Tags:** Primary keyword + related terms (5-10 tags)
- **Featured Image:** Always include (1200×630px recommended)
- **SEO Plugin:** Fill in meta title + meta description (Yoast/RankMath)
- **Schema:** Set article type to "BlogPosting"

### Google Business Profile Post
Short version of the blog (max 1500 characters):
```
[Compelling opening — 1 sentence]

[Core insight from the blog — 3-4 sentences]

[One actionable tip]

🔗 Read the full guide: [URL]
📞 [Your CTA — contact, booking link, etc.]

#[YourNiche] #[YourCity] #[RelevantHashtag]
```

### Google Blogger
Casual short-form version (400-600 words):
- More conversational tone
- Focus on one key insight from the full post
- Always link back to main website for full version
- Great for extra Google ecosystem authority

---

## Blog Topic Generator

**Prompt to generate 20 blog ideas for your niche:**
```
Generate 20 blog post ideas for [BUSINESS NAME] in the [NICHE] industry targeting [AUDIENCE] in [LOCATION].
Include a mix of: how-to guides, listicles, opinion pieces, and case study topics.
For each idea, provide: title | primary keyword | search intent | estimated difficulty (low/medium/high)
```

---

## Seasonal Blog Calendar Template

| Month | Theme | Blog Post Idea | Keyword Focus |
|-------|-------|---------------|---------------|
| January | New Year Goals | "How to [Achieve Goal] in [Year]" | [your keyword] |
| February | Valentine's/Partnership | "[Service] for [couples/teams]" | [your keyword] |
| March | Spring Reset | "Spring [Topic] Guide" | [your keyword] |
| April | Q2 Planning | "[Industry] Strategy for Q2" | [your keyword] |
| May | Growth Season | "Scaling Your [Topic]" | [your keyword] |
| June | Mid-Year Review | "[Industry] Mid-Year Checklist" | [your keyword] |
| July | Summer Tips | "[Topic] in Summer" | [your keyword] |
| August | Preparation | "Preparing for [Fall Topic]" | [your keyword] |
| September | Fresh Start | "September Reset: [Topic]" | [your keyword] |
| October | Q4 Planning | "[Industry] Q4 Strategy" | [your keyword] |
| November | Year-End Tips | "Before Year-End: [Checklist]" | [your keyword] |
| December | Reflection + Preview | "Looking Back, Looking Forward" | [your keyword] |

---

## Use with ContentAI Suite

This skill works seamlessly with **[ContentAI Suite](https://contentai-suite.vercel.app)** — a free multi-agent marketing platform that generates, optimizes, and publishes blog posts to WordPress automatically.

→ **Try it free:** https://contentai-suite.vercel.app
