---
name: "Blockchain"
description: "Understand blockchain technology, interact with smart contracts, and evaluate when distributed ledgers solve real problems."
---

## What This Covers

Blockchain fundamentals and practical interaction — the technology, not the speculation.

**In scope:** Distributed ledgers, consensus, transactions, smart contract interaction, wallets, token standards.
**Out of scope:** Trading strategies, price analysis, specific DeFi protocols, Solidity development (see dedicated skills).

## Core Concepts

| Concept | One-liner |
|---------|-----------|
| Distributed ledger | Shared database synchronized across nodes, no single owner |
| Consensus | How strangers agree on truth without trusting each other |
| Immutability | Changing history requires re-doing all subsequent work |
| Smart contract | Code that executes automatically when conditions are met |
| Gas | Fee paid to network for computation |

For mental models and analogies, see `concepts.md`.

## Developer Quick Reference

```typescript
// Read contract (viem)
const balance = await client.readContract({
  address: TOKEN, abi: erc20Abi,
  functionName: 'balanceOf', args: [wallet]
})

// Write requires wallet + confirmation wait
const hash = await walletClient.writeContract({...})
const receipt = await client.waitForTransactionReceipt({ hash })
```

Common traps: missing allowance checks, wrong decimals (ETH=18, USDC=6), not awaiting confirmations.

For full patterns, see `dev.md`.

## When to Use Blockchain

✅ **Use when:** Multiple parties need shared truth, no trusted authority exists, immutability is critical, settlement costs are high.

❌ **Don't use when:** Single org controls data, you trust a central authority, data needs deletion (GDPR), or a database solves it.

> **The Database Test:** Would PostgreSQL with audit logs solve this? If yes, skip blockchain.

For decision framework and enterprise platforms, see `evaluation.md`.

## Security Essentials

- Seed phrase = master key — never share, never screenshot
- Hardware wallet > software wallet > exchange
- Test transactions before large transfers
- Verify URLs obsessively — phishing clones are sophisticated

For wallet security and scam patterns, see `security.md`.
