---
name: blackclaw
description: "Real-time crypto risk intelligence; before and as things break. Two tools: Flare (15-min precursor detection, immediate alarms) and Core (60-min state synthesis, context assessment). Free access to the last analysis. No API key required. Upgrade to x402 for custom analysis."
homepage: https://github.com/blackswanwtf/blackswan-mcp
metadata: {"emoji": "🦢", "requires": {"bins": ["curl"]}}
---

# BlackSwan Risk Intelligence

BlackSwan monitors crypto markets 24/7 and produces two risk assessments:

- **Flare** — Precursor detection from a 15-minute signal window. Use for immediate, alarm-bell risk checks. Before the news breaks.
- **Core** — State synthesis from a 60-minute signal window. Use for market context and risk assessment. As the news breaks.

## When to use each tool

| Question | Tool |
|----------|------|
| "Is something happening right now?" | Flare |
| "What's the overall market risk environment?" | Core |
| "Should I be worried about sudden moves?" | Flare |
| "Give me a full risk briefing" | Both (Flare first, then Core) |

## Base URL

```
https://mcp.blackswan.wtf
```

## Endpoints

### GET /api/flare

Returns the latest Flare precursor detection assessment.

```bash
curl -s https://mcp.blackswan.wtf/api/flare
```

**Response fields:**

| Field | Description |
|-------|-------------|
| `agent` | Always `"flare"` |
| `data_age` | Human-readable age of the data (e.g. "12 minutes ago") |
| `status` | `"clear"` or `"alert"` |
| `severity` | `"none"`, `"low"`, `"medium"`, `"high"`, or `"critical"` |
| `checked_at` | ISO 8601 timestamp of the assessment |
| `assessment` | Natural language risk assessment |
| `signals` | Array of detected signals, each with `type`, `source`, and `detail` |

### GET /api/core

Returns the latest Core state synthesis assessment.

```bash
curl -s https://mcp.blackswan.wtf/api/core
```

**Response fields:**

| Field | Description |
|-------|-------------|
| `agent` | Always `"core"` |
| `data_age` | Human-readable age of the data (e.g. "1 hour ago") |
| `timestamp` | ISO 8601 timestamp of the assessment |
| `environment` | `"stable"`, `"elevated"`, `"stressed"`, or `"crisis"` |
| `assessment` | Natural language risk assessment |
| `key_factors` | Array of strings describing the main risk factors |
| `sources_used` | Array of data source names used in the assessment |
| `data_freshness` | Description of how fresh the underlying data is |

## Interpreting severity levels (Flare)

| Severity | Meaning |
|----------|---------|
| `none` | No precursors detected, markets quiet |
| `low` | Minor signals, worth noting but not actionable |
| `medium` | Notable signals, warrants attention |
| `high` | Strong precursors detected, elevated risk of sudden moves |
| `critical` | Extreme signals, immediate risk of major market event |

## Interpreting environment levels (Core)

| Environment | Meaning |
|-------------|---------|
| `stable` | Normal market conditions, low systemic risk |
| `elevated` | Above-normal risk, some stress indicators present |
| `stressed` | Significant stress across multiple indicators |
| `crisis` | Severe market stress, active dislocation or contagion |

## Error handling

| HTTP Status | Meaning |
|-------------|---------|
| `200` | Success, response contains full assessment |
| `502` | Agent output failed validation — format may have changed |
| `503` | No recent agent runs — system may be starting up |
| `500` | Unexpected server error |

On non-200 responses, the body is `{"error": "..."}` with a human-readable message.

## Complete risk check pattern

To get a full picture, call both endpoints:

```bash
curl -s https://mcp.blackswan.wtf/api/flare
curl -s https://mcp.blackswan.wtf/api/core
```

Present Flare results first (immediate risks), then Core (broader context).
