---
name: blacksnow
description: Detects pre-news ambient risk signals across human, legal, and operational systems and converts them into machine-readable, tradable risk primitives.
---

# BlackSnow

**Invisible Risk Exhaust → Tradable Signal Engine**

BlackSnow is an economic sensor skill that ingests fragmented, low-signal, legally accessible data exhaust from multiple non-obvious domains. It applies ontology alignment, weak-signal Bayesian accumulation, and horizon forecasting to surface early risk vectors before formal events, news, or disclosures occur.

Outputs are structured for automated consumption by financial, insurance, logistics, and policy systems.

## Core Capabilities

- **Ambient Risk Detection**: Surfaces pre-event signals invisible to traditional monitoring
- **Weak-Signal Correlation**: Connects individually meaningless data points into predictive patterns
- **Cross-Domain Ontology Fusion**: Aligns heterogeneous inputs into unified risk primitives
- **Probabilistic Forecasting**: Estimates outcome likelihoods and temporal windows
- **Tradable Signal Packaging**: Converts internal risk states into sellable primitives

## Non-Capabilities

- ❌ Insider information
- ❌ Sentiment analysis
- ❌ News aggregation
- ❌ Price prediction
- ❌ Decision execution

## What BlackSnow Detects

Signals that exist weeks earlier, fragmented across obscure, low-signal sources:

### Micro-Behavioral Shifts
- Municipal procurement wording changes
- Infrastructure maintenance deferrals
- Insurance clause revisions
- Supply contract force-majeure language

### Operational Anomalies
- Unexpected overtime tenders
- Silent vendor substitutions
- Emergency inventory buffering

### Legal Entropy
- Draft regulation language drift
- Repeated consultation extensions
- Committee member attendance decay

### Human System Stress
- Attrition spikes in critical roles
- Hiring freezes masked as "role realignment"
- Union grievance language tone shifts

## Output Schema

```json
{
  "risk_vector": "infra.energy.grid",
  "signal_confidence": 0.87,
  "time_horizon_days": "21-45",
  "contributing_domains": ["procurement", "maintenance", "labor"],
  "likely_outcomes": [
    "localized outage",
    "price volatility",
    "policy intervention"
  ],
  "tradability": {
    "insurance": true,
    "commodities": true,
    "logistics": true,
    "policy": false
  }
}
```

## Agents

| Agent | Role | Description |
|-------|------|-------------|
| `harvester` | Ingestion | Collects obscure, legally accessible data exhaust from approved domains |
| `normalizer` | Semantic Alignment | Maps heterogeneous inputs into a unified risk ontology |
| `accumulator` | Probabilistic Reasoning | Performs Bayesian evidence accumulation over time |
| `forecaster` | Horizon Modeling | Estimates outcome likelihoods and temporal windows |
| `packager` | Monetization Interface | Converts internal risk states into sellable signal primitives |

## Data Sources

### Allowed
- Public procurement notices
- Regulatory draft documents
- Contract language revisions
- Maintenance and tender logs
- Labor and union filings
- Hiring and attrition metadata
- Inventory and logistics metadata

### Forbidden
- Private communications
- Leaked documents
- Paywalled sources without license
- Personal identifiable information

## Monetization Tiers

| Tier | Access | Price |
|------|--------|-------|
| Observer | Aggregated heatmaps | $99/mo |
| Operator | Raw risk vectors | $1,500/mo |
| Fund/API | Real-time streaming signals | $10k–50k/mo |
| Sovereign | Custom domains & exclusivity | $250k+/yr |

### Add-ons
- Region exclusivity
- Early-signal SLA
- Historical backtesting
- Compliance attestation

## Integration

Compatible skills:
- `tradebot`
- `hedgecore`
- `logistics-router`
- `policy-simulator`

Chaining mode: `async`

## Constraints

### Legal
- GDPR compliant
- No personal data storage
- No market manipulation intent

### Ethical
- No targeted individual profiling
- No civilian harm forecasting

### Operational
- Explainability not guaranteed
- Probabilistic outputs only

## Risk Disclaimer

BlackSnow provides probabilistic risk intelligence, not predictions or advice. Users are solely responsible for downstream decisions and compliance.

## Status

- **Deployment**: Sandbox
- **Onboarding**: Gated
- **Audit Required**: Yes
