---
name: bits-mcp
description: Control browser automation agents via the Bits MCP server. Use when running web scraping, form filling, data extraction, or any browser-based automation task. Bits agents can navigate websites, click elements, fill forms, handle OAuth flows, and extract structured data.
---

# Bits MCP - Browser Automation

Bits is an AI browser automation platform. The MCP server lets you run browser automation tasks from your AI assistant.

## Setup

### 1. Get an API Key

1. Go to [app.usebits.com](https://app.usebits.com)
2. Sign in with Google
3. Navigate to **Settings → API Keys**
4. Click **Create API Key**, give it a name
5. Copy the key (starts with `bb_`) — you won't see it again

### 2. Configure MCP

Add to your MCP config (e.g., `~/.openclaw/openclaw.json`):

```json
{
  "mcpServers": {
    "bits": {
      "command": "npx",
      "args": ["-y", "usebits-mcp"],
      "env": {
        "BITS_API_KEY": "bb_your_key_here"
      }
    }
  }
}
```

For Claude Code (`~/.claude.json`):

```json
{
  "mcpServers": {
    "bits": {
      "command": "npx",
      "args": ["-y", "usebits-mcp"],
      "env": {
        "BITS_API_KEY": "bb_your_key_here"
      }
    }
  }
}
```

### 3. Restart

Restart your gateway/client to pick up the new MCP server.

## Usage

The Bits MCP uses "Code Mode" — you write TypeScript SDK code that executes in a sandbox. Two tools are available:

1. **Documentation search** — Query the SDK docs
2. **Code execution** — Write and run TypeScript against the Bits SDK

### Example: Scrape a Website

```
Use the Bits MCP to go to news.ycombinator.com and get the top 5 story titles
```

The agent will:
1. Search docs for navigation/scraping methods
2. Write TypeScript code to navigate and extract data
3. Execute it and return results

### Example: Fill a Form

```
Use Bits to go to example.com/contact, fill out the contact form with name "Test" and email "test@example.com", then submit
```

### Example: Extract Structured Data

```
Use Bits to scrape the product listings from example-store.com/products and return them as JSON with name, price, and URL fields
```

## Capabilities

- **Navigate** — Go to URLs, handle redirects
- **Read pages** — Extract text, get page layouts, take screenshots
- **Interact** — Click elements, fill inputs, press keys
- **Handle auth** — OAuth popups, login forms, 2FA (with stored credentials)
- **Multi-window** — Switch between tabs/popups
- **Structured output** — Return data in specific JSON schemas

## Creating Workflows (Optional)

For repeated tasks, create a workflow in the Bits web app:

1. Go to [app.usebits.com](https://app.usebits.com) → **Workflows**
2. Create a workflow with a definition (instructions for the agent)
3. Optionally add an output schema for structured responses
4. Run via API: `POST /workflows/{id}/runs`

## Troubleshooting

**"API key invalid"** — Check your key starts with `bb_` and is copied correctly.

**Slow startup** — First run downloads the MCP package via npx. Subsequent runs are faster.

**Task stuck** — Browser automation can hit CAPTCHAs or unexpected modals. Check the live view URL in the response.

## Links

- Web app: [app.usebits.com](https://app.usebits.com)
- API docs: [api.usebits.com/openapi.json](https://api.usebits.com/openapi.json)
