# Supported Product Categories

Categories sourced from the Bitrefill `/api/omni` response. For the latest offerings and availability, always check [bitrefill.com](https://www.bitrefill.com).

## Gift Cards

Digital gift cards for popular brands, delivered as redeemable codes.

### Categories (from API)

| Category slug | Description |
|---------------|-------------|
| automobiles | Automotive brands |
| top-products | Most popular products |
| all-gift-cards | All available gift cards |
| retail | General retail stores |
| apparel | Clothing and fashion |
| health-beauty | Health and beauty products |
| home | Home and household |
| electronics | Electronics and tech |
| pets | Pet supplies and services |
| food | Food and groceries |
| restaurants | Restaurant gift cards |
| food-delivery | Food delivery services |
| payment-cards | Prepaid payment cards |
| multi-brand | Multi-brand / multi-store cards |
| groceries | Grocery stores |
| streaming | Streaming services (video, music) |
| games | Gaming platforms and credits |
| travel | General travel |
| flights | Flight bookings |
| cruises | Cruise bookings |
| train | Train travel |
| bus | Bus travel |
| car-rental | Car rental services |
| pharmacy | Pharmacy and drugstores |
| music | Music services and stores |
| entertainment | Entertainment and media |
| literature | Books and reading |
| experiences | Experience gifts |
| gifts | General gift options |
| voip | VoIP and calling services |
| utility-bills | Utility bill payments |
| digital-wallet | Digital wallet top-ups |
| online-marketplaces | Online marketplace credits |
| online-travel-agencies | OTA credits (Booking, etc.) |
| accommodation | Hotel and accommodation |
| department-stores | Department store cards |
| sports-n-outdoors | Sports and outdoor brands |
| phone-services | Phone service credits |
| transportation | Transportation services |
| gasoline | Fuel and gas stations |
| vpn | VPN service subscriptions |
| payment-voucher | Payment vouchers |
| kids | Kids and family |
| amazon | Amazon gift cards (all regions) |
| bitcoin | Bitcoin-related products |
| game-stores | Game store credits |
| in-game-currencies | In-game currency top-ups |
| cosmetics | Cosmetics and beauty |
| spa | Spa and wellness |
| natural-herbal-care | Natural and herbal care |
| electricity | Electricity bill payments |

Availability is per country. Many brands have region-specific cards (e.g. Amazon US, UK, DE).

## Mobile Top-ups (Refills)

Prepaid airtime and data for mobile numbers in 200+ countries.

### Subcategories (from API)

| Category slug | Description |
|---------------|-------------|
| refill | Standard airtime top-up |
| data | Data-only packages |
| pin | PIN-based top-ups |
| bundles | Combined voice + data bundles |
| dth | Direct-to-home (TV recharge) |

- Most major carriers supported.
- Top-up is applied to the phone number.
- Denominations vary by carrier and country.

## eSIMs

Travel data plans for 190+ countries.

- **Discovery hub:** Full list and browse by All / Country / Region at **bitrefill.com/esim/all-destinations**.
- Product slugs are kebab-case (e.g. `bitrefill-esim-japan`, `bitrefill-esim-global`, `bitrefill-esim-taiwan`).
- Data-only (no voice/SMS).
- Durations: e.g. 1, 7, 15, 30 days; data from around 1GB to unlimited.
- Regional plans (e.g. Europe, Asia, Americas).
- Activate via QR code; install before or during travel.
- Compatible with most modern smartphones (e.g. iPhone XS+, recent Android).

## Bitcoin & Lightning Services

- Lightning channel opening and liquidity services.
- Bitcoin payment processing tools.

## General Notes

- **Country restrictions:** Many products are region-locked. Verify the user's country matches the product.
- **Denominations:** Gift card values typically from about $5 to $500, depending on brand.
- **Currency:** Prices can be shown in the user's local currency; crypto is converted at checkout.
- **Catalog changes:** Bitrefill adds and updates brands and products; use the site or API for the current catalog.
