# Birdfolio — Data Schemas

All data lives in `{workspace}/birdfolio/`. File paths below are relative to that directory.

---

## config.json

Created by `init_birdfolio.py`. Updated by `log_sighting.py`.

```json
{
  "version": 1,
  "setupDate": "2026-02-20",
  "homeRegion": "California",
  "regions": ["California"],
  "totalSightings": 12,
  "totalSpecies": 8
}
```

| Field | Type | Description |
|-------|------|-------------|
| `version` | int | Schema version (always 1 for v1) |
| `setupDate` | string | ISO date when Birdfolio was set up |
| `homeRegion` | string | User's primary region |
| `regions` | string[] | All regions (v1: single-element array) |
| `totalSightings` | int | Running count of all logged sightings |
| `totalSpecies` | int | Count of unique species (lifers only) |

---

## checklist.json

Created by `init_birdfolio.py` (empty stubs). **Populated by the agent** using `write_file` after You.com search.
Updated by `update_checklist.py` when a sighting is logged.

```json
{
  "California": {
    "common": [
      { "species": "American Robin",  "slug": "american-robin",  "found": false, "dateFound": null },
      { "species": "House Sparrow",   "slug": "house-sparrow",   "found": true,  "dateFound": "2026-02-20" },
      { "species": "Anna's Hummingbird", "slug": "annas-hummingbird", "found": false, "dateFound": null }
    ],
    "rare": [
      { "species": "Great Blue Heron", "slug": "great-blue-heron", "found": false, "dateFound": null }
    ],
    "superRare": [
      { "species": "California Condor", "slug": "california-condor", "found": false, "dateFound": null }
    ]
  }
}
```

**Checklist counts per region:**
- `common`: 10 species
- `rare`: 5 species
- `superRare`: 1 species

| Field | Type | Description |
|-------|------|-------------|
| `species` | string | Common name (must match exactly for `update_checklist.py`) |
| `slug` | string | Lowercase hyphenated name for file paths |
| `found` | bool | Whether the user has spotted this species |
| `dateFound` | string\|null | ISO date when found, or null |

---

## lifeList.json

Appended by `log_sighting.py`. Read by `get_stats.py`.

```json
[
  {
    "id": "sighting-001",
    "commonName": "American Robin",
    "scientificName": "Turdus migratorius",
    "slug": "american-robin",
    "rarity": "common",
    "region": "California",
    "date": "2026-02-20T14:32:00+00:00",
    "isLifer": true,
    "notes": "Spotted in backyard eating berries",
    "cardSent": false
  }
]
```

| Field | Type | Description |
|-------|------|-------------|
| `id` | string | Sequential ID (`sighting-001`, `sighting-002`, …) |
| `commonName` | string | Common name of the species |
| `scientificName` | string | Latin binomial |
| `slug` | string | Lowercase hyphenated name |
| `rarity` | string | `"common"`, `"rare"`, or `"superRare"` |
| `region` | string | Region where spotted |
| `date` | string | ISO 8601 datetime (UTC) |
| `isLifer` | bool | `true` if first ever sighting of this species |
| `notes` | string | Optional observer notes |
| `cardSent` | bool | Whether a trading card was generated (agent can update) |

---

## birds/{slug}.json  *(optional)*

The agent may write per-species detail files here for caching You.com results.

```json
{
  "commonName": "American Robin",
  "scientificName": "Turdus migratorius",
  "slug": "american-robin",
  "rarity": "common",
  "region": "California",
  "funFact": "American Robins can produce up to three broods per year.",
  "habitat": "Gardens, parks, woodlands",
  "range": "Year-round across most of North America",
  "imageUrl": "https://example.com/robin.jpg",
  "lastUpdated": "2026-02-20"
}
```

---

## cards/{slug}-{timestamp}.png

Screenshot of the card, saved automatically by `screenshot_card.js` alongside the HTML.
Path format: `{workspace}/birdfolio/cards/american-robin-20260220143200.png`

---

## cards/{slug}-{timestamp}.html

Generated by `generate_card.py`. Self-contained HTML with embedded base64 image.
Path format: `{workspace}/birdfolio/cards/american-robin-20260220143200.html`

The agent screenshots this file via `screenshot_card.js`, which saves a PNG alongside the HTML and returns `{pngPath}`. Send the PNG via the `message` tool.
