---
name: bird-twitter
description: Twitter/X CLI wrapper using bird — post tweets, reply, read, search, and manage your timeline. Fast GraphQL-based X CLI.
version: 1.0.0
author: cyzi
tags: [twitter, x, tweet, social, timeline, search]
metadata: {"openclaw":{"emoji":"🐦","skillKey":"bird-twitter","primaryEnv":"AUTH_TOKEN","requires":{"bins":["bird"],"env":["AUTH_TOKEN","CT0"]}}}
---

# Bird Twitter Skill 🐦

Fast Twitter/X CLI wrapper using `bird` — post tweets, reply, read, search, and manage your timeline via Twitter's GraphQL API.

## Required Environment Variables

```bash
export AUTH_TOKEN=<your_twitter_auth_token>
export CT0=<your_twitter_ct0_cookie>
```

### How to Get Tokens

1. Log in to Twitter/X in your browser
2. Open Developer Tools (F12)
3. Go to Application/Storage → Cookies → twitter.com
4. Copy:
   - `auth_token` → `AUTH_TOKEN`
   - `ct0` → `CT0`

## Quick Usage

```bash
# Check login status
bird whoami

# Check credential availability
bird check

# Post a tweet
bird tweet "Hello from bird-twitter skill!"

# Reply to a tweet
bird reply <tweet-id-or-url> "Great thread!"

# Read a tweet
bird read <tweet-id-or-url>

# Read with JSON output
bird read <tweet-id-or-url> --json

# Search tweets
bird search "query"

# Get home timeline
bird home

# Get mentions
bird mentions

# Get liked tweets
bird likes

# Follow a user
bird follow <username>

# Get user's tweets
bird user-tweets <handle>

# Get trending topics
bird news
bird trending
```

## Commands

### Posting

| Command | Description |
|---------|-------------|
| `bird tweet <text>` | Post a new tweet |
| `bird reply <url> <text>` | Reply to a tweet |
| `bird tweet <text> --media <path>` | Tweet with media (up to 4 images or 1 video) |

### Reading

| Command | Description |
|---------|-------------|
| `bird read <url>` | Read/fetch a tweet |
| `bird thread <url>` | Show full conversation thread |
| `bird replies <url>` | List replies to a tweet |
| `bird user-tweets <handle>` | Get user's tweets |

### Timelines

| Command | Description |
|---------|-------------|
| `bird home` | Home timeline ("For You" feed) |
| `bird mentions` | Tweets mentioning you |
| `bird likes` | Your liked tweets |
| `bird bookmarks` | Your bookmarked tweets |

### Search & Discovery

| Command | Description |
|---------|-------------|
| `bird search <query>` | Search tweets |
| `bird news` | AI-curated news from Explore |
| `bird trending` | Trending topics |

### Account Management

| Command | Description |
|---------|-------------|
| `bird whoami` | Show logged-in account |
| `bird check` | Check credential availability |
| `bird follow <user>` | Follow a user |
| `bird unfollow <user>` | Unfollow a user |
| `bird followers` | List your followers |
| `bird following` | List users you follow |
| `bird lists` | Your Twitter lists |

## Output Options

| Option | Description |
|--------|-------------|
| `--json` | JSON output |
| `--json-full` | Include raw API response |
| `--plain` | Plain text (no emoji, no color) |
| `--no-emoji` | Disable emoji |
| `--no-color` | Disable ANSI colors |
| `--timeout <ms>` | Request timeout |

## Configuration

Reads from:
- `~/.config/bird/config.json5`
- `./.birdrc.json5`

Supports: `chromeProfile`, `firefoxProfile`, `cookieTimeoutMs`, `timeoutMs`, `quoteDepth`

## Environment Variables

| Variable | Description |
|----------|-------------|
| `AUTH_TOKEN` | **Required** — Twitter auth_token cookie |
| `CT0` | **Required** — Twitter ct0 cookie |
| `NO_COLOR` | Disable colors |
| `BIRD_TIMEOUT_MS` | Default timeout |
| `BIRD_COOKIE_TIMEOUT_MS` | Cookie extraction timeout |
| `BIRD_QUOTE_DEPTH` | Max quoted tweet depth |

## Examples

```bash
# Check who's logged in
bird whoami

# Post a simple tweet
bird tweet "Hello world from OpenClaw!"

# Post with an image
bird tweet "Check this out!" --media ./image.png

# Reply to a tweet
bird reply 1234567890123456789 "Thanks for sharing!"

# Search for tweets about AI
bird search "artificial intelligence" --json

# Get your home timeline
bird home -n 20

# Read a tweet thread
bird thread https://x.com/user/status/1234567890

# Get trending topics
bird trending
```

## Troubleshooting

### 401 Unauthorized
Check that `AUTH_TOKEN` and `CT0` are set and valid. Run `bird check` to verify.

### Token Expired
Twitter tokens expire periodically. Re-copy from browser cookies.

### Rate Limited
Twitter GraphQL API has rate limits. Wait a few minutes and retry.

---

**TL;DR**: Fast Twitter/X CLI via bird. Set `AUTH_TOKEN` and `CT0`, then tweet, read, search, and manage your timeline!
