# Bird Info Skill - 鸟类信息查询

一个自动从懂鸟网站查询鸟类信息的技能。

## 功能特点

- 🐦 支持中文、英文、学名查询
- 🔍 智能模糊匹配
- 📖 自动提取鸟类详细信息
- 🌍 包含分布、保护状况、图片等信息

## 安装

技能已自动安装到: `/home/leo/.openclaw/workspace/skills/bird-info`

## 使用方法

### 方法1: 使用命令行工具

```bash
# 查询中文名
bird-info "麻雀"

# 查询英文名
bird-info "Sparrow"

# 查询学名
bird-info "Passer domesticus"
```

### 方法2: 通过对话

直接告诉我你想查询的鸟，例如:
- "帮我查一下麻雀的信息"
- "喜鹊的详细资料"
- "绿孔雀的分布区域"
- "丹顶鹤的保护状况"

## 输出示例

```
========================================
🐦 麻雀 - 鸟类详细信息
========================================

📌 基本信息
-----------
中文名: 麻雀
英文名: House Sparrow
学名: Passer domesticus
科: 雀科
目: 雀形目

🌍 分布
------
主要分布: 中国各地、欧洲、亚洲北部
栖息环境: 人类居住区、农田、城市绿地

📖 描述
------
体长: 约14-16厘米
体重: 约20-30克
特征: 头部有明显的黑白花纹，背部褐色，腹部白色

⚠️ 保护状况
-----------
IUCN评级: 无危 (LC)
中国保护等级: 无危

📷 相关图片
----------
[图片链接]
```

## 技术实现

### 工作流程

1. **接收查询**: 获取用户输入的鸟名
2. **规范化**: 标准化鸟名格式
3. **搜索**: 在懂鸟网站分类页面中搜索
4. **定位**: 找到匹配的鸟类条目
5. **详情**: 导航到详情页提取信息
6. **格式化**: 整理成易读的格式

### 页面结构

- **分类页**: 层级树状结构（目 → 科 → 种）
- **详情页**: 基本信息、描述、分布、保护状况、图片

## 数据来源

- **网站**: [懂鸟](https://dongniao.net)
- **数据库**: IOC 14.1 世界鸟类名录
- **覆盖范围**: 全面的鸟类分类数据库

## 限制

- 数据库覆盖范围有限，并非所有鸟类都包含
- 需要网络连接访问懂鸟网站
- 图片信息可能不完整

## 未来增强

- [ ] 支持更多鸟类数据库
- [ ] 多物种比较功能
- [ ] 导出功能（PDF、Markdown）
- [ ] 鸟叫声识别（如可用）
- [ ] 搜索过滤（地区、栖息地、保护等级）

## 注意事项

1. **准确性**: 信息来自公开数据库，建议交叉验证
2. **用途**: 适用于学习和了解，非专业科研
3. **尊重**: 观鸟时应遵守当地法规，不干扰鸟类

## 故障排除

### 鸟类未找到

- 检查拼写是否正确
- 尝试使用中文名或英文名
- 确认该鸟是否在数据库中

### 页面加载慢

- 检查网络连接
- 稍后重试
- 直接访问 https://dongniao.net 查看是否有其他问题

## 相关资源

- [懂鸟网站](https://dongniao.net)
- [IOC鸟类名录](https://www.worldbirdnames.org/)
- [中国鸟类图鉴](https://www.birdwatch.cn/)

---

**提示**: 如果需要查询特定鸟类的详细信息，请告诉我鸟的名字，我会帮您操作。
