---
name: binance-dca
description: Binance Dollar-Cost Averaging (DCA) tool for automated and manual recurring crypto purchases. Use when the user wants to plan DCA strategies, execute recurring buys on Binance, check DCA projections, view trade history, or manage a systematic buying schedule for any trading pair (BTC/USDT, ETH/USDT, etc). Triggers on requests about DCA, recurring buys, cost averaging, accumulation strategies, or Binance spot purchases.
---

# Binance DCA

Execute and plan Dollar-Cost Averaging strategies on Binance.

## Setup

Requires two environment variables (never hardcode these):

```bash
export BINANCE_API_KEY="your-key"
export BINANCE_SECRET_KEY="your-secret"
```

Optional: `BINANCE_BASE_URL` (defaults to `https://api.binance.com`). Use `https://testnet.binance.vision` for paper trading.

## Quick Start

```bash
# Check current BTC price
bash scripts/dca.sh price BTCUSDT

# Project a DCA plan: $50 every 7 days, 12 buys
bash scripts/dca.sh plan 50 7 12 BTCUSDT

# Execute a $50 market buy
bash scripts/dca.sh buy BTCUSDT 50

# Check recent trades
bash scripts/dca.sh history BTCUSDT 10

# Check USDT balance
bash scripts/dca.sh balance USDT
```

## Actions

### price [SYMBOL]
Get current spot price. Default: BTCUSDT.

### balance [ASSET]
Check free and locked balance for an asset. Default: USDT.

### buy SYMBOL AMOUNT [TYPE] [PRICE]
Place a buy order. AMOUNT is in quote currency (USDT).
- `MARKET` (default): Execute immediately at market price
- `LIMIT`: Requires price parameter — `buy BTCUSDT 50 LIMIT 95000`

### history [SYMBOL] [LIMIT]
Show recent trades with timestamps, side, quantity, price, and fees.

### plan [AMOUNT] [FREQ_DAYS] [NUM_BUYS] [SYMBOL]
Project a DCA plan with scenario analysis showing PnL at different price levels (-30% to +100%). Defaults: $50, every 7 days, 12 buys, BTCUSDT.

## DCA Strategy Guidance

When helping users plan DCA:

1. **Ask about budget** — How much per buy, and how often?
2. **Set expectations** — DCA smooths volatility, not guaranteed profit
3. **Run projections** — Use `plan` to show scenarios before committing
4. **Recommend testnet first** — Set `BINANCE_BASE_URL=https://testnet.binance.vision`
5. **Position sizing** — Suggest 1-2% of portfolio per buy for conservative approach
6. **Never store credentials** — Always use environment variables

## Scheduling DCA Buys

For automated recurring buys, suggest setting up a cron job or OpenClaw cron:

```
# Example: buy $50 BTC every Monday at 9am UTC
0 9 * * 1 BINANCE_API_KEY=... BINANCE_SECRET_KEY=... /path/to/dca.sh buy BTCUSDT 50
```

Or via OpenClaw cron for agent-managed scheduling with alerts and confirmations.

## Error Handling

- Missing API keys → clear error message with setup instructions
- Invalid amounts → validation before API call
- API failures → descriptive error with endpoint info
- Always verify the order response status before confirming to user
