---
name: bililidownloader
description: Download Bilibili videos. You MUST ask the user for the Bilibili URL first. Then use the provided python script to download. Supports batch/playlist downloading.
---

# Bilibili视频下载器

## 描述
此技能用于下载B站视频。
**重要：在使用此技能前，必须先询问用户获取视频的URL地址。**
支持单个视频和合集的下载。能够智能检测系列视频，提供格式选择，并显示下载进度。

## 功能
- 解析B站链接，判断是否为系列视频
- 显示系列视频总数
- 提供批量下载选项
- 支持视频格式和清晰度选择
- 实时显示下载进度
- 下载完成后通知结果

## 参数 (CLI参数)
- url: B站视频链接（必需）
- --batch: 自动批量下载系列视频（可选）
- --no-batch: 仅下载单个视频（可选）
- --format / -f: 视频格式ID（可选，默认为最高可用质量）

## 依赖
- python >= 3.6
- yt-dlp
- ffmpeg

## 使用示例

### 对话流程
用户: "下载B站视频"
AI: "好的，请告诉我视频的链接（URL）是什么？"
用户: "https://www.bilibili.com/video/BV1xxx"
AI: (执行下载脚本)

### 命令示例
```bash
# 基本下载
python3 scripts/download_bilibili.py "https://www.bilibili.com/video/BV1xxx"

# 批量下载
python3 scripts/download_bilibili.py "https://www.bilibili.com/video/BV1xxx" --batch
```

## 工作流程
1. **询问用户视频URL**
2. 解析提供的B站URL
3. 检测是否为系列视频
4. (可选) 根据用户意图使用 --batch 或 --no-batch
5. 执行下载脚本
7. 实时显示下载进度
8. 下载完成后报告成功或失败状态

## 注意事项
- 如遇VIP内容或地区限制，可能需要提供cookie
- 下载速度取决于网络状况和B站服务器
- 遵守B站使用条款，仅用于个人学习和备份目的