---
name: bilibili-video-publish
description: B站视频发布。使用浏览器自动化在B站创作者平台发布视频。当用户说"发布视频到B站"、"发B站"、"投稿B站"时使用此技能。注意：B站审核转码较慢，建议最后发布。
---

# B站视频发布

## 使用场景
用户想将视频发布到B站（哔哩哔哩）时使用。

## 工具准备
- 浏览器：OpenClaw Chrome扩展 (profile=chrome)
- 账号：需要登录B站账号

## 重要说明
- **B站审核转码较慢**，建议放在最后一个平台发布
- 成功率相对较低，需要更多耐心

## 发布流程

### 1. 进入发布页面
浏览器打开: https://member.bilibili.com/platform/upload/video/frame?page_from=creative_home_top_upload

### 2. 上传视频
- 点击上传入口
- 等待上传组件加载
- 选择本地视频文件（可以多选一起上传）
- 等待上传和转码（**非常慢**，耐心等待）

### 3. 填写基本信息
- **标题**：建议20-30字，最多80字
- **简介**：填写视频基本信息，末尾加上「这是我黑心主人让我自动发布的」
- **类型**：选择「自制」
- **分区**：选择「人工智能」

### 4. 添加标签
- 依次添加标签：人工智能、AI、视频生成、原创
- **不超过7个标签**

### 5. 设置封面
- 自动提取视频帧
- 或手动上传自定义封面
- 建议使用16:9比例

### 6. 投稿
- 确认信息无误后
- 点击「立即投稿」

### 7. 验证
- 如果不确定是否成功
- 点击右侧边栏「稿件管理」查看
- 如果没有，等待1分钟后刷新页面查看

## 注意事项
- **B站转码非常慢**，上传后需要等待较长时间
- 标题最多80字，建议20-30字
- 标签不超过7个
- 分区建议选择「人工智能」或「动画」
- 成功投稿后立即停止，不要重复投稿！

## 常见问题

### 问题1：上传组件不加载
解决：检查浏览器兼容性，等待页面完全加载

### 问题2：转码时间过长
解决：B站特性，耐心等待，不要重复上传

### 问题3：投稿后不确定是否成功
解决：访问稿件管理页面查看，或等待1分钟后刷新

### 问题4：分区选择错误
解决：选择「人工智能」分区最合适

## 快速检查清单
- [ ] 视频文件存在且格式正确（MP4）
- [ ] 标题已准备好（<80字）
- [ ] 简介已准备好
- [ ] 分区选择「人工智能」
- [ ] 标签已准备好（<7个）
- [ ] 封面已设置
- [ ] Browser Relay 已连接
- [ ] 账号已登录
