# ✅ 清洁版学习笔记质量检查清单

快速检查生成的学习笔记是否符合高质量标准。

---

## 📋 内容质量 (5项)

- [ ] **知识点数量**: 6-10个核心知识点
- [ ] **字数平衡**: 每个知识点200-400字
- [ ] **核心概念**: 20-30字,简洁有力,便于快速扫描
- [ ] **关键要点**: 3-5个bullet points,每个1句话
- [ ] **多维度**: 包含现象+原因+方案+案例

---

## 🎨 格式规范 (5项)

- [ ] **标题层级**: 正确使用#/##/###/####
- [ ] **术语标注**: 重要术语**粗体**,技术术语`代码格式`
- [ ] **列表格式**: 统一使用`-`或`1.`
- [ ] **图片尺寸**: 统一宽度600px
- [ ] **相对路径**: `screenshots/screenshot_XXX.jpg`

---

## 📸 截图质量 (4项)

- [ ] **数量**: 10张关键截图
- [ ] **分布**: 均匀覆盖视频全程
- [ ] **清晰度**: 无模糊或过渡帧
- [ ] **关联性**: 每张截图对应知识点内容

---

## 📚 总结完整性 (4项)

- [ ] **知识框架**: 用分层结构梳理逻辑关系
- [ ] **实践价值**: 3-4个维度(质量控制/问题诊断/成本控制等)
- [ ] **学习建议**: 6条可操作建议
- [ ] **动词开头**: 多观察/勤对比/善记录/重实操/懂类型/会判断

---

## 🔧 技术实现 (3项)

- [ ] **字幕提取**: 使用`parse_srt_file()`获取完整文本
- [ ] **批量截图**: ffmpeg精准截取,`-y`强制覆盖
- [ ] **JSON安全**: `ensure_ascii=False` + `encoding='utf-8'`

---

## ⚠️ 常见问题避坑 (4项)

- [ ] **避免信息过载**: 每个知识点不超过500字
- [ ] **避免图文不符**: 截图必须与知识点强关联
- [ ] **避免JSON错误**: 使用`json.dumps()`,不手动拼接
- [ ] **避免大段文字**: 用小标题和列表分割内容

---

## 🎯 专业性标准 (3项)

- [ ] **领域术语**: 保留专业术语(如"SA-β-Gal染色")
- [ ] **具体参数**: 保留数值(如"P2-P5代"、"80%融合度")
- [ ] **准确性**: 对比原字幕验证信息准确性

---

## 总分: ____ / 28

**评分标准**:
- 28分: 完美 ⭐⭐⭐⭐⭐
- 25-27分: 优秀 ⭐⭐⭐⭐
- 22-24分: 良好 ⭐⭐⭐
- 19-21分: 合格 ⭐⭐
- <19分: 需改进 ⭐

---

**参考案例**: `reports/2026-02-28/BV1ms4y1Y76i_细胞聚团原因剖析/细胞聚团原因剖析_学习笔记.md` (28/28分)
