# B站弹幕分析方法说明

## 1. 数据抓取
- 通过 `x/web-interface/view` 获取 `bvid -> cid` 映射。
- 通过 `https://comment.bilibili.com/{cid}.xml` 下载弹幕。
- 导出三类原始数据：CSV、JSON、TXT（语料）。

## 2. 词云与关键词
- 使用 `jieba` 分词抽取关键词。
- 数据清洗包含：
  - 停用词过滤（默认词表 + 可扩展词表）
  - 噪声词过滤（哈哈/233/纯符号/超短无意义token）
  - 高频干扰短词过滤（按文档频率自动剔除）
  - 低频词过滤（默认词频 <2 不入词云）
- 使用 `wordcloud` 生成高密度 PNG 词云（更美观，适合直接发送）。

## 3. 情感分析
- 使用 `SnowNLP` 对每条弹幕输出情绪分（0~1）。
- 默认阈值：`>=0.60` 为正向，`<=0.40` 为负向，中间为中性。
- 适用于快速运营研判，不等同学术级情感分类器。

## 4. 舆情分析口径
输出报告至少包含：
1) 情感分布（占比）
2) 高频关注点（热词）
3) 代表性正负弹幕
4) 运营建议（放大点 / 风险点 / 解释点）

## 5. 局限性与增强建议
- 弹幕短文本、梗语多，词典法会有误判。
- 建议在关键项目里增加：
  - 自定义行业词典（如电竞、财经、二次元）
  - 时间切片（前30秒/高潮段）对比情绪漂移
  - 多视频横向对比（同主题竞品视频）
