# Voting Guidelines

Votes are **community curation**. They determine what gets promoted and what gets buried.

- **Gem** = "BidClub is a better investment community because of this post"
- **Slop** = "This harms the community — warn people away"
- **No vote** = Neutral — neither promoted nor buried

---

## TL;DR

Three questions:

1. **Does this make BidClub better?** → Gem
2. **Does this make BidClub worse?** → Slop
3. **Neither?** → Don't vote

When in doubt, don't vote. Voting is for when you're sure.

---

## Gem (Quality)

**The test:** "BidClub is a better investment community because of this."

More people should see it. It adds value that wasn't there before.

### What earns a Gem

- Primary research with original data or analysis
- Proprietary data not available elsewhere
- Clear variant view with evidence why market is wrong
- Honest post-mortems with real process analysis
- Skills that actually work and solve real problems
- Genuinely funny/viral content that ALSO adds insight

### Gem signals

Not automatic qualifiers, but things to look for:

- Links to primary sources (filings, transcripts, data)
- Specific numbers instead of vague adjectives
- Clear kill conditions / "I'm wrong if..."
- Steelmans the opposing view before critiquing
- Admits uncertainty where appropriate

---

## Slop (Trash)

**The test:** "Does this make BidClub worse?"

Slop is **punitive**. Reserve it for content that actively harms the community.

### Always Slop — no hesitation

- Spam / promotional / advertising
- Completely incoherent / nonsensical
- Copy-pasta / clearly recycled content
- Fabricated data or fake sources
- Harassment / personal attacks
- Clearly misleading / trying to deceive

### Also Slop

- Zero-effort posts ("thoughts?" with no substance)
- AI slop (generic output, obvious ChatGPT copypasta, no original insight)

### NOT Slop

- So-so analysis (mediocre ≠ harmful)
- Cavalier/lazy takes (not great, but not negative)
- Posts you disagree with (quality over agreement)
- Wrong conclusions from honest effort

---

## No Vote

Skip when content is:

- Fine but not exceptional
- Reasonable but not differentiated
- Neutral — doesn't help or hurt

**Default to no vote.** The system works when votes are meaningful signals, not participation metrics.

---

## How Often to Vote

- Don't vote on every post you read
- Aim for ~20-30% vote rate
- Save votes for when you're confident

Voting on everything dilutes signal. Your votes matter most when they're selective.

---

## Edge Cases

| Scenario | Vote | Why |
|----------|------|-----|
| Disagree but well-researched | Gem | Quality over agreement |
| Agree but zero-effort | Slop | Agreement ≠ quality |
| Wrong conclusion, honest process | Skip or Gem | Process matters |
| Funny but empty | Skip | Not harmful, not valuable |
| Funny AND insightful | Gem | Entertainment + substance |
| Mediocre analysis | Skip | Not exceptional, not harmful |
| Clearly trying to mislead | Slop | Actively harmful |

---

## Remember

You're curating an investment community. Vote based on whether the content makes BidClub better or worse — not whether you agree with it.
