---
name: Bible
description: Accurate Bible study with proper citations, cross-references, original language insights, and interpretation methodology.
---

## Citation Format (Critical)

**Standard format**: Book Chapter:Verse — "John 3:16", "Genesis 1:1", "1 Corinthians 13:4-8"

**Common errors to prevent**:
- ❌ "Psalms 23" → ✅ "Psalm 23" (always singular)
- ❌ "1st Corinthians" → ✅ "1 Corinthians"
- ❌ Mixing translations in same quote
- ❌ Verse range doesn't match quoted text

**Single-chapter books**: Include chapter — "Jude 1:3", "Philemon 1:6", "3 John 1:4"

**Always identify translation**: "John 3:16 (ESV)" or specify at passage start.

## Cross-Reference Patterns

**Core themes with key verses**:
- Faith: Romans 1:17, Hebrews 11:1, James 2:17
- Love: 1 Corinthians 13:4-8, 1 John 4:8, John 13:34-35
- Salvation: Ephesians 2:8-9, Romans 3:23-24, John 3:16
- Grace: Ephesians 2:8, Romans 5:8, Titus 2:11

**OT→NT fulfillment**: Always show prophetic connection when relevant.

## Original Language Terms

**Hebrew (OT)**: Hesed (covenant love), Shalom (peace/wholeness), Ruach (spirit/breath), Kavod (glory)

**Greek (NT)**: Agape (divine love), Pistis (faith), Charis (grace), Koinonia (fellowship)

**Word study method**: Root word → usage across authors → semantic range → theological development

## Translation Categories

**Word-for-word** (study): NASB, ESV — most literal
**Thought-for-thought** (reading): NIV, NLT, CSB — balanced clarity
**Paraphrase** (devotional): MSG — fresh perspective, not for doctrine

## Interpretation Principles

**Genre-specific rules**:
- Narrative: Plot, character, moral lessons
- Wisdom: Practical principles, not absolute promises
- Prophecy: Near/far fulfillment, literal vs symbolic
- Parables: One central truth per parable
- Epistles: Doctrine with practical application

**Context hierarchy**: Immediate verses → chapter → book purpose → biblical theology → systematic theology

**Progressive revelation**: Later Scripture clarifies earlier. NT fulfills OT types/shadows.

## Common AI Errors

**Citation errors**: Verify every reference. Don't paraphrase and call it a quote. Check verse ranges match actual text.

**Context violations**: Never proof-text. Consider surrounding verses. Don't impose modern concepts on ancient text.

**Interpretation errors**: Clear passages interpret unclear. Scripture interprets Scripture. Distinguish description from prescription.
