# Bible Research Methodology Reference

## Contents
1. [Harmonizing Apparently Contradictory Scriptures](#harmonizing)
2. [Reasoning from the Scriptures Pattern](#reasoning-pattern)
3. [Key Topics & Core Scripture Lists](#key-topics)
4. [Effective wol.jw.org Search Patterns](#wol-search)
5. [NWT URL Patterns](#nwt-urls)
6. [Insight on the Scriptures: Common Entry Keywords](#insight-entries)

---

## 1. Harmonizing Apparently Contradictory Scriptures {#harmonizing}

When two scriptures seem to conflict:

1. **Read both in full context** — What is the overall theme of each chapter/book?
2. **Check the audience** — Was this written to Israel under the Law? The early Christian congregation? All mankind?
3. **Check the time frame** — Does one scripture apply to a past covenant or a future fulfillment?
4. **Check the literary genre** — Is it poetry (Psalms), prophecy, narrative, or doctrinal exposition?
5. **Look up both passages in wol.jw.org** — Study notes often explain the apparent tension.
6. **Search *Insight on the Scriptures*** — Frequently addresses apparent Bible contradictions under the relevant topic heading.
7. **Apply the "weight of evidence" principle** — The correct understanding harmonizes ALL related scriptures, not just two.

### Example: "No one has seen God" (John 1:18) vs. Moses/Abraham appearing before God

- Context: John 1:18 refers to God's full divine glory — no human can see that and survive (Exodus 33:20).
- Patriarchs saw angelic representatives of Jehovah (Exodus 33:11 — "face to face" = familiar, direct communication, not literal vision of divine essence).
- Harmonized understanding: God communicates through his Son/angels; his full person remains beyond human sight.

---

## 2. Reasoning from the Scriptures Pattern {#reasoning-pattern}

From the *Reasoning from the Scriptures* book methodology:

```
QUESTION (the objection or topic raised)
↓
SCRIPTURE (one clear, direct verse — read it aloud/quote it)
↓
REASON (explain what the verse says in plain language)
↓
ILLUSTRATION (optional — use a simple analogy)
↓
CROSS-REFERENCE (bring in 1-2 supporting scriptures)
↓
CONCLUSION (restate the Bible's clear teaching)
```

### Example: "Is the soul immortal?"

**Question:** What happens to a person when they die?

**Scripture:** Ecclesiastes 9:5 (NWT) — "For the living know that they will die, but the dead know nothing at all..."

**Reason:** The scripture plainly states the dead have no consciousness. There is no immortal soul that survives death in a conscious state.

**Cross-reference:** Genesis 2:7 — The soul is not something separate from the body; the person *became* a living soul when God's breath entered the dust. Ezekiel 18:4 — "The soul that sins — it will die."

**Conclusion:** The Bible teaches that the soul can die and that hope lies in the resurrection, not in an immortal soul going to heaven or hell.

---

## 3. Key Topics & Core Scripture Lists {#key-topics}

### God's Name (Jehovah)
- Psalm 83:18; Exodus 3:15; Isaiah 42:8; John 17:6, 26; Revelation 4:11

### Jesus — Son of God, Not God
- John 14:28; Colossians 1:15; 1 Corinthians 11:3; John 17:3; Acts 2:36; Proverbs 8:22-30

### Holy Spirit — God's Active Force (not a person)
- Genesis 1:2; Psalm 104:30; Joel 2:28; Acts 2:4; John 14:26 (note: *it*, not *he*, in original)

### God's Kingdom
- Daniel 2:44; 7:13-14; Matthew 6:9-10; Luke 17:20-21; Revelation 11:15

### Soul & Death (Soul-sleep)
- Genesis 2:7; Ecclesiastes 9:5, 10; Ezekiel 18:4; John 11:11-14; Romans 6:23

### Resurrection Hope
- John 5:28-29; Acts 24:15; 1 Corinthians 15:20-23, 42-44; Revelation 20:12-13

### Paradise Earth
- Psalm 37:9-11, 29; Isaiah 65:21-25; Matthew 5:5; Revelation 21:3-4; 2 Peter 3:13

### Last Days
- 2 Timothy 3:1-5; Matthew 24:3-14; Luke 21:10-11; Revelation 6:1-8

### Blood — Why Abstain
- Genesis 9:4; Leviticus 17:14; Acts 15:28-29; John 6:53 (context critical)

### Holidays — Why JWs Don't Celebrate
- Jeremiah 10:1-4 (Christmas trees); 1 Corinthians 10:20-21; Matthew 15:3-9; Colossians 2:8

### 144,000 and Great Crowd
- Revelation 7:4-9; 14:1-5; Luke 12:32; Romans 8:17; John 10:16

### Disfellowshipping / Association with Wrongdoers
- 1 Corinthians 5:11-13; 2 Thessalonians 3:14-15; 2 John 10-11

---

## 4. Effective wol.jw.org Search Patterns {#wol-search}

### Via tavily-search-pro

**For a Bible topic:**
```
query: site:wol.jw.org "<topic>"
example: site:wol.jw.org "soul" "insight on the scriptures"
```

**For a specific publication:**
```
query: site:wol.jw.org insight "<keyword>"
query: site:wol.jw.org "reasoning from the scriptures" "<topic>"
query: site:wol.jw.org watchtower "<topic>" study article
```

**For a scripture's study notes:**
```
query: site:wol.jw.org study note "<book> <chapter>:<verse>"
example: site:wol.jw.org study note "John 1:1"
```

**For recent Watchtower articles:**
```
query: site:wol.jw.org watchtower 2023 "<topic>"
(adjust year for most recent)
```

### Direct wol.jw.org URL Structures

| Resource | URL Pattern |
|---|---|
| NWT Bible (English) | `https://wol.jw.org/en/wol/b/r1/lp-e/nwtsty/` |
| Insight on the Scriptures Vol 1 | `https://wol.jw.org/en/wol/d/r1/lp-e/1200001497` |
| Insight on the Scriptures Vol 2 | `https://wol.jw.org/en/wol/d/r1/lp-e/1200001498` |
| Reasoning from the Scriptures | `https://wol.jw.org/en/wol/d/r1/lp-e/1101989192` |
| What Does the Bible Really Teach? | `https://wol.jw.org/en/wol/d/r1/lp-e/1102005148` |

---

## 5. NWT URL Patterns {#nwt-urls}

The wol.jw.org NWT URL uses numeric book codes. Use `web_fetch` on:
```
https://wol.jw.org/en/wol/b/r1/lp-e/nwtsty/<BOOK_NUM>/<CHAPTER>
```

### Book Number Reference (key books)

| Book | Number | Book | Number |
|---|---|---|---|
| Genesis | 1 | Matthew | 40 |
| Exodus | 2 | Mark | 41 |
| Psalms | 19 | Luke | 42 |
| Proverbs | 20 | John | 43 |
| Ecclesiastes | 21 | Acts | 44 |
| Isaiah | 23 | Romans | 45 |
| Jeremiah | 24 | 1 Corinthians | 46 |
| Ezekiel | 26 | Galatians | 48 |
| Daniel | 27 | Colossians | 51 |
| Malachi | 39 | 1 Timothy | 54 |
| — | — | 2 Timothy | 55 |
| — | — | Hebrews | 58 |
| — | — | Revelation | 66 |

**Example:** John chapter 3 → `https://wol.jw.org/en/wol/b/r1/lp-e/nwtsty/43/3`

**Fallback:** If direct URL fetch fails, use tavily extract mode on the URL, or search:
```
site:wol.jw.org "<Book Chapter:Verse>" NWT
```

---

## 6. Insight on the Scriptures: Common Entry Keywords {#insight-entries}

When doing a word study, search wol.jw.org for these exact entry phrases:

- `"insight" "soul"` — SOUL entry (nefesh/psyche)
- `"insight" "spirit"` — SPIRIT entry (ruach/pneuma)
- `"insight" "love"` — LOVE entry (agape/philia)
- `"insight" "hell"` — HELL entry (sheol/hades/gehenna)
- `"insight" "name"` — NAME entry (shem/onoma) + "insight" "jehovah"
- `"insight" "kingdom"` — KINGDOM entry
- `"insight" "resurrection"` — RESURRECTION entry
- `"insight" "trinity"` — TRINITY entry
- `"insight" "baptism"` — BAPTISM entry
- `"insight" "blood"` — BLOOD entry

All searches: prefix with `site:wol.jw.org`

---

## Greek & Hebrew Quick Reference

| Greek Word | Transliteration | Meaning |
|---|---|---|
| ψυχή | psyche | soul, life, person (NOT immortal spirit) |
| πνεῦμα | pneuma | spirit, breath, active force |
| ᾅδης | hades | the grave, realm of the dead |
| γέεννα | gehenna | destruction, not eternal torment |
| ἀγάπη | agape | unconditional, principled love |
| φιλία | philia | warm friendship/affection |
| μονογενής | monogenes | only-begotten (unique Son) |
| παρουσία | parousia | presence (not "coming" alone) |
| αἰών | aion | age, eon (not always "eternal") |

| Hebrew Word | Transliteration | Meaning |
|---|---|---|
| נֶפֶשׁ | nefesh | soul, person, living being |
| רוּחַ | ruach | spirit, breath, wind, life-force |
| שְׁאוֹל | sheol | the grave, common burial place |
| יְהוָה | YHWH | Jehovah — God's personal name |
| עוֹלָם | olam | age, long time (context-dependent) |
