# Berlin Visitor Tips & Day Trips

## Essential Tips

### Money
- **Cash is king** — Many restaurants, bars, Spätis are cash-only
- **ATMs**: Use bank ATMs (Sparkasse, Deutsche Bank), avoid Euronet (high fees)
- **Tipping**: 5-10% at restaurants, round up at bars
- **No Amex**: Rarely accepted, Visa/Mastercard sometimes

### Getting Around
- **BVG app**: Buy tickets, plan routes
- **No barriers**: Honor system — but €60 fine if caught without ticket
- **Validation**: Must validate paper tickets before boarding
- **Bikes**: Deutsche Bahn "Call a Bike" or Lime scooters everywhere

### Communication
- **English**: Widely spoken in central Berlin, less in outer districts
- **German attempts**: Appreciated but not expected
- **"Hallo"**: Standard greeting (not "Guten Tag" which is formal)
- **"Tschüss"**: Casual goodbye

### Local Customs
- **Punctuality**: Germans are on time. Be on time.
- **Eye contact when toasting**: Prost with eye contact, or "7 years bad sex"
- **Quiet on transit**: Keep voices down on U-Bahn/S-Bahn
- **Right side standing**: Stand right on escalators, walk left
- **Dogs everywhere**: Normal, restaurants/transit-friendly

### Safety
- **Very safe**: One of Europe's safest capitals
- **Watch for**: Bike theft (lock well), pickpockets (tourist spots)
- **Night safety**: Generally fine, some caution in parks late night
- **Protests**: Frequent, usually peaceful, may block transit

## Berlin Vocabulary

| German | English | Context |
|--------|---------|---------|
| Späti | Late-night shop | 24/7 corner stores |
| Kiez | Neighborhood | Local area |
| Kneipen | Pubs | Casual bars |
| Pfand | Deposit | Bottle return for €0.08-0.25 |
| Feierabend | After-work | End of workday beer |
| Kater | Hangover | Literal: "tomcat" |
| Gemütlichkeit | Coziness | Comfortable atmosphere |
| Maß | 1L beer | "Mass" - Bavarian but available |

## Day Trips from Berlin

### Potsdam (Highly Recommended)
- **Distance**: 45 min S-Bahn (S7)
- **Why**: Sanssouci Palace, gardens, Dutch Quarter
- **Time needed**: Full day
- **Cost**: S-Bahn covered by ABC ticket, palace €19-22
- **Tip**: Rent bikes at station, cycle between palaces

### Sachsenhausen Memorial
- **Distance**: 45 min S-Bahn (S1) + 20 min walk
- **Why**: Nazi concentration camp memorial, important history
- **Time needed**: 3-4 hours
- **Cost**: Free (donations welcome), audio guide €3
- **Note**: Heavy experience, prepare mentally

### Spreewald
- **Distance**: 1-1.5 hrs by regional train
- **Why**: UNESCO biosphere, canal boat tours, pickles
- **Time needed**: Full day
- **Best**: Summer for kayaking, fall for colors
- **Tip**: Book punt boat tour in advance (Kahnfahrten)

### Dresden
- **Distance**: 2 hrs by ICE
- **Why**: Rebuilt baroque city, Zwinger Palace, Frauenkirche
- **Time needed**: Full day or overnight
- **Cost**: €40-50 train (book ahead for cheaper)

### Hamburg
- **Distance**: 1.5 hrs by ICE
- **Why**: Harbor city, Elbphilharmonie, Reeperbahn
- **Time needed**: Overnight recommended
- **Cost**: €30-60 train (book ahead)

### Tropical Islands (Unusual)
- **Distance**: 1 hr south
- **Why**: Tropical waterpark in former airship hangar
- **Why not**: Very touristy, crowded, expensive
- **Best for**: Families, escaping winter grey

## Seasonal Tips

### Summer (Jun-Aug)
- **Book outdoor things**: Beer gardens packed
- **Lakes**: Wannsee, Müggelsee, Schlachtensee
- **Open-air cinema**: Multiple venues
- **Berghain queue**: 3+ hours on summer weekends

### Winter (Dec-Feb)
- **Grey warning**: 4pm sunset, limited daylight affects mood
- **Indoor focus**: Museums, cafes, saunas
- **Christmas markets**: Best in late November/early December
- **Ice skating**: Potsdamer Platz, others

### Events Worth Planning Around
- **Berlinale** (Feb): Film festival, book early
- **Carnival of Cultures** (May): Kreuzberg parade, lively
- **Fête de la Musique** (June 21): Free music citywide
- **Berlin Marathon** (Sep): Road closures but great atmosphere
- **Festival of Lights** (Oct): Buildings illuminated

## Locals' Secrets

- **Klunkerkranich**: Rooftop bar in Neukölln parking garage
- **Teufelsberg**: Cold War spy station ruins, street art
- **Badeschiff**: Floating pool on Spree river
- **Prinzessinnengarten**: Urban garden in Kreuzberg
- **Haubentaucher**: Pool club in Friedrichshain (summer)
- **Molecule Man**: Giant sculpture, best viewed from boat
