# Berlin Visa Guide (Feb 2026)

## Quick Reference

| Your Situation | Visa Type | Key Requirement |
|----------------|-----------|-----------------|
| EU/EEA citizen | None needed | Just Anmeldung |
| Job offer in hand | Work Visa | Employer sponsors |
| High-skill job offer | EU Blue Card | €45,300+ salary |
| Looking for job | Job Seeker Visa | 6 months to search |
| Freelance/consulting | Freelance Visa | Client contracts |
| Starting business | Self-Employment | Business plan |
| Student | Student Visa | University admission |
| Spouse of resident | Family Reunion | Partner has residence |

## EU/EEA/Swiss Citizens

**No visa required**. Full work rights.

**Still needed**:
1. Anmeldung (address registration)
2. Tax ID (automatic after Anmeldung)
3. Health insurance

## EU Blue Card

Best option for high-skilled workers.

### Requirements
- University degree (recognized in Germany)
- Job offer or contract
- **Salary**: €45,300+/year (€41,042 for shortage occupations)
- Health insurance
- No criminal record

### Shortage Occupations (Lower Threshold)
- IT/Software
- Engineering
- Medical professionals
- Natural scientists

### Process
1. Job offer secured
2. Employer provides contract
3. Apply at German embassy (home country) OR Ausländerbehörde (if already in Germany legally)
4. Processing: 1-3 months

### Benefits
- PR after 21 months (with B1 German) or 33 months
- Bring family
- Work authorization included
- Travel within EU

## Work Visa (Regular)

For jobs not qualifying for Blue Card.

### Requirements
- Job offer from German employer
- Employer must prove no EU candidate available (Vorrangprüfung, often waived)
- Qualifications matching job
- Health insurance

### Process
1. Employer provides contract
2. Apply at embassy
3. Ausländerbehörde finalizes in Germany
4. Processing: 2-4 months

## Job Seeker Visa

Find a job while in Germany.

### Requirements
- University degree (recognized)
- Funds for 6-month stay (~€5,000)
- Health insurance
- Return ticket

### Details
- Valid 6 months
- Cannot work during search
- If job found: convert to work visa
- Apply at German embassy

## Freelance Visa (Freiberufler)

Berlin's unique opportunity for self-employed professionals.

### Qualifying Professions
- Software developers, IT consultants
- Designers (UX, graphic, etc.)
- Writers, translators
- Artists, musicians
- Consultants
- Coaches, trainers

### Requirements
- Portfolio/CV showing expertise
- Client interest letters (German clients helpful)
- Business plan (simple)
- Financial projection
- Health insurance
- Funds (~€5,000+)

### Process
1. Arrive on tourist visa (90 days)
2. Gather documents
3. Apply at Ausländerbehörde Berlin
4. Interview (often in German, bring translator)
5. Processing: 2-6 months (can stay while pending)

### Tips
- German clients strengthen application
- Show clear income potential
- Professional website helps
- Letters of intent from clients
- Accountant letter helpful

## Self-Employment Visa

For business founders (more complex than Freiberufler).

### Requirements
- Business plan
- Economic need in region
- Funding secured (€250,000 minimum investment, or)
- Create 5+ jobs
- Chamber of Commerce approval

### Reality
- Harder than Freelance visa
- Requires more capital
- Consider Freelance visa first, scale later

## Student Visa

### Requirements
- University admission
- Proof of funds (€11,208/year in blocked account)
- Health insurance
- Language proficiency (for program)

### Details
- Can work 120 full days or 240 half days/year
- Convert to work visa after graduation (18 months to find job)

## Family Reunion

### Spouse of German/EU Citizen
- Basic German (A1) usually required
- Marriage certificate
- Financial stability

### Spouse of Non-EU Resident
- Sponsor must have residence permit
- A1 German
- Adequate housing
- Financial means

## Ausländerbehörde Berlin

### Reality Check
- Appointments book 2-3 months ahead
- Website: service.berlin.de
- Bring ALL documents
- Extra copies of everything
- Translator if needed
- Patience essential

### Tips
- Book earliest possible appointment
- Check cancellations daily
- Arrive early
- Bring water, snacks
- Stay calm

## Permanent Residence (Niederlassungserlaubnis)

After 5 years (21-33 months with Blue Card):
- German B1 level
- Pension contributions (60 months)
- Self-sufficient
- Adequate housing
- No criminal record

## Citizenship

After 8 years (6-7 years possible):
- German B1
- Pass citizenship test
- Renounce previous (exceptions exist)
- Self-sufficient
- No criminal record

### New Rules (2024+)
- Dual citizenship now easier
- 5 years possible for "special integration"
- Check current regulations
