# Berlin Transport Guide

## Overview

Berlin has excellent public transit (BVG + S-Bahn). Most residents don't own cars.

**Zones**:
- **A**: City center (inside S-Bahn ring)
- **B**: Outer city (to city border)
- **C**: Brandenburg (Potsdam, Schönefeld, etc.)

Most people only need AB. Add C for airport or Potsdam trips.

## U-Bahn (Metro)

**Lines**: U1-U9
**Hours**: 4am-1am weekdays, 24h Fri-Sat
**Frequency**: 3-10 min (varies by line/time)

**Key Lines**:
| Line | Route | Notes |
|------|-------|-------|
| U1 | Kreuzberg-Friedrichshain | Yellow line, elevated |
| U2 | West-East through center | Alexanderplatz |
| U5 | Alexanderplatz-East | Extended to Hbf 2020 |
| U6 | North-South | Friedrichstraße |
| U7 | Longest line | Neukölln, Kreuzberg |
| U8 | North-South alternative | Wedding, Neukölln |

## S-Bahn (City Rail)

**Lines**: S1-S9, S25, S26, S41/S42 (ring), S45-S47
**Hours**: 4am-1am weekdays, 24h Fri-Sat
**Frequency**: 5-20 min

**Key Lines**:
| Line | Route | Notes |
|------|-------|-------|
| S41/S42 | Ringbahn (circle) | Clockwise/counter |
| S1 | Potsdam-North | Zone C for Potsdam |
| S5/S7/S75 | East-West | Alexanderplatz, Zoo |
| S9 | Airport (BER) | Zone C ticket |

## Trams

**Areas**: Mostly East Berlin (Mitte, Prenzlauer Berg, Friedrichshain)
**Lines**: M (metro tram) + regular numbers
**Hours**: Similar to U-Bahn

Useful for: Prenzlauer Berg, Mitte north

## Buses

**Coverage**: Everywhere
**Night**: N-lines run when trains don't
**Useful**: M29 (Kreuzberg), 100/200 (tourist routes)

## Tickets & Fares (Feb 2026)

| Ticket | Price | Valid |
|--------|-------|-------|
| Single AB | €3.50 | 2 hours, one direction |
| Short trip (Kurzstrecke) | €2.40 | 3 stops S/U or 6 stops bus/tram |
| Day ticket AB | €8.80 | Until 3am next day |
| 7-day AB | €41.00 | 7 consecutive days |
| Monthly AB | €86.00 | Calendar month |
| Annual AB | €899 | Best value for residents |

**Zone C additions**:
- Single ABC: €4.40
- Day ABC: €10.40

### Apps for Tickets
- **BVG app**: Official, buy tickets, live times
- **Jelbi**: Multimodal (transit + bike + car share)
- **DB Navigator**: For longer S-Bahn + regional trains

### Important Rules
1. **No barriers** - Honor system, but inspectors exist
2. **Validate tickets** - Paper tickets must be stamped before boarding
3. **Fine**: €60 for riding without valid ticket
4. **Inspectors**: Plain clothes, ask "Fahrausweis bitte"
5. **Dogs**: Free with muzzle, or small in bag

## Cycling

### Infrastructure
- Extensive bike lanes (improving)
- Many dedicated paths
- Can take bikes on transit (off-peak, €2.20 day ticket)

### Bike Sharing
| Service | Type | Cost |
|---------|------|------|
| Nextbike | Docked | €1/15min |
| Lime | Dockless | Unlock + per min |
| Tier | E-scooter | Unlock + per min |

### Buying a Bike
- **Decathlon**: Budget new bikes
- **Fahrrad Herz**: Used, quality
- **eBay Kleinanzeigen**: Private sales
- **Warning**: High theft - ALWAYS lock properly

### Lock Strategy
- Two different lock types
- Lock frame AND wheel
- U-lock + chain recommended
- Don't leave overnight outside

## Taxis & Ride-Hailing

### Taxi
- **Hail**: On street or taxi stand
- **App**: FreeNow (formerly MyTaxi)
- **Base fare**: €4.00 + €2.00/km (approx)
- **Tip**: Round up or 5-10%

### Ride-Hailing
- **Bolt**: Usually cheapest
- **Uber**: Available, uses licensed drivers
- **FreeNow**: Taxis + Uber-style

### When to Use
- Late night when transit limited
- Bad weather
- Luggage
- Group (cost split makes sense)

## Airport (BER)

### Getting There
| Method | Time | Cost |
|--------|------|------|
| S-Bahn (S9/S45) | 30-45 min | €4.40 (ABC) |
| FEX (express train) | 30 min | €4.40 (ABC) |
| Taxi | 30-45 min | €50-70 |
| Bus (X7, X71) | 45+ min | €4.40 |

**Recommendation**: S9 or FEX from Hauptbahnhof

### Terminals
- **T1**: Main terminal, most flights
- **T2**: Low-cost carriers
- **T5**: Old Schönefeld (now closed)

## Car Sharing

### Services
| Service | Type | Best For |
|---------|------|----------|
| SIXT Share | One-way | Flexible trips |
| SHARE NOW | One-way | Short trips |
| Miles | Per-km | Longer trips |

### Parking
- Street parking: Blue zone (€2-4/hour) or free
- Parking garages: €2-3/hour
- Apps: PayByPhone, ParkNow

### Do You Need a Car?
**No** if:
- Living inside Ring
- Working accessible by transit
- No regular out-of-city trips

**Maybe** if:
- Family with kids
- Regular IKEA/bulk shopping
- Weekend trips outside city
