# Berlin Tech Industry Guide

## Overview

Berlin is Germany's startup capital and a major European tech hub.

### Tech Scene Stats
- **Startups**: 3,000+ active
- **Tech employees**: 100,000+
- **VC invested (2023)**: €4B+
- **Unicorns**: N26, Delivery Hero, HelloFresh, Trade Republic, etc.

### Why Berlin for Tech
- Lower cost than London/Paris
- International (English OK)
- Strong startup culture
- Good talent pool
- Quality of life
- EU market access

## Salaries (Feb 2026)

### Software Engineering

| Level | Salary Range | Notes |
|-------|--------------|-------|
| Junior (0-2 yrs) | €45,000-55,000 | Entry level |
| Mid (2-5 yrs) | €55,000-75,000 | Independent work |
| Senior (5+ yrs) | €75,000-95,000 | Tech lead capable |
| Staff/Principal | €95,000-130,000 | Rare, large companies |
| Engineering Manager | €90,000-120,000 | People management |

### Other Tech Roles

| Role | Mid-Level | Senior |
|------|-----------|--------|
| Product Manager | €65,000-80,000 | €80,000-100,000 |
| UX Designer | €50,000-65,000 | €65,000-85,000 |
| Data Scientist | €60,000-80,000 | €80,000-100,000 |
| DevOps/SRE | €65,000-85,000 | €85,000-110,000 |
| Engineering Manager | €90,000-110,000 | €110,000-130,000 |

### Compensation Notes
- **Base salary**: Most important, quoted above
- **Equity**: Common in startups, varies wildly
- **Bonus**: 10-20% in larger companies
- **Benefits**: Usually health, sometimes BVG ticket, gym
- **Remote**: Increasingly negotiable

## Major Tech Employers

### Large Tech Companies
| Company | Focus | Size |
|---------|-------|------|
| Zalando | E-commerce | 15,000+ |
| Delivery Hero | Food delivery | 10,000+ |
| HelloFresh | Meal kits | 8,000+ |
| N26 | Digital banking | 1,500+ |
| Trade Republic | Trading | 1,000+ |
| Auto1 | Used cars | 5,000+ |
| Personio | HR software | 2,000+ |
| Contentful | CMS | 500+ |
| SoundCloud | Music | 300+ |

### International Tech Offices
- Google (significant office)
- Amazon (multiple teams)
- Microsoft
- Stripe
- Datadog
- MongoDB
- Elastic

### Startup Scene
Areas by stage:
- **Early stage**: Kreuzberg, Neukölln
- **Growth stage**: Mitte
- **Scale-ups**: Mitte, Friedrichshain

## Finding Jobs

### Job Boards
| Site | Type |
|------|------|
| LinkedIn | Universal |
| Glassdoor | Reviews + jobs |
| StackOverflow Jobs | Engineering |
| Berlin Startup Jobs | Startups |
| AngelList | Startups |
| Honeypot | Tech, reverse apply |
| Hired | Tech, reverse apply |

### Tips
- English job = English interview (usually)
- German helps but not required for tech
- Network at meetups
- Direct company applications often better

## Tech Hubs & Coworking

| Space | Location | Vibe |
|-------|----------|------|
| Factory Berlin | Mitte | Premium startup hub |
| Mindspace | Multiple | Corporate + startups |
| WeWork | Multiple | Standard coworking |
| Betahaus | Kreuzberg | Creative, original |
| St. Oberholz | Mitte | Cafe + coworking |
| Ahoy! | Mitte | Affordable |

## Meetups & Community

### Regular Events
- **Berlin.js**: JavaScript community
- **PyBerlin**: Python meetups
- **Rust Berlin**: Rust language
- **Tech Open Air**: Annual conference
- **Women Who Code**: Female developers
- **Startup Grind**: Entrepreneur events

### Finding Meetups
- Meetup.com
- Eventbrite
- LinkedIn Events
- Company Slack communities

## Freelancing in Tech

### Freelance Rates (Daily)
| Level | Rate |
|-------|------|
| Junior | €400-500 |
| Mid | €500-700 |
| Senior | €700-1,000 |
| Specialist | €1,000-1,500 |

### Freelance Reality
- **Visa**: Freelance visa possible (Freiberufler)
- **Taxes**: Quarterly Umsatzsteuer, annual Einkommensteuer
- **Insurance**: Must arrange own (health, liability)
- **Clients**: Often through agencies or platforms
- **Platforms**: Toptal, Malt, 9am

## Work Culture

### What to Expect
- **Hours**: 40/week standard, some startups more
- **Vacation**: 25-30 days typical + holidays
- **Remote**: Negotiable, 2-3 days office common
- **Hierarchy**: Flatter than traditional German
- **Language**: English in tech, German in admin
- **After-work**: Beer common, not mandatory
