# Berlin Startup Guide

## Why Berlin for Startups

### Advantages
- **Cost**: 40-60% cheaper than London/SF
- **Talent**: International, English-speaking
- **VC access**: Strong European investors
- **Quality of life**: Work-life balance culture
- **EU market**: 450M consumers, single market
- **Visa friendly**: Freelance/startup visas available

### Disadvantages
- **German bureaucracy**: Real and frustrating
- **Language**: Admin still requires German
- **Scaling**: Smaller than US market
- **Exits**: Fewer big exits than US
- **Winter**: Affects mood, productivity

## Startup Ecosystem

### Key Players

**Accelerators**
| Program | Focus | Investment |
|---------|-------|------------|
| Techstars Berlin | General tech | $120K |
| Founders Factory | Corporate-backed | Varies |
| APX (Porsche/Springer) | Mobility, media | €50K |
| Entrepreneur First | Pre-idea | £60K |
| Next Big Thing | IoT, hardware | €25K |

**Incubators**
- Factory Berlin (community, not equity)
- Berlin Startup Academy
- German Accelerator (scaling US)

### VC Landscape

**Berlin-Based VCs**
| Fund | Stage | Check Size |
|------|-------|------------|
| Cherry Ventures | Early | €0.5-5M |
| Cavalry Ventures | Seed | €0.5-2M |
| Project A | Early | €0.5-10M |
| Point Nine | SaaS, marketplaces | Seed |
| Earlybird | Multi-stage | €1-50M |
| HV Capital | Multi-stage | €1-100M |
| Atlantic Labs | Early | €0.2-3M |

**European VCs Active in Berlin**
- Balderton (UK)
- Northzone (Nordic)
- Index Ventures (UK/US)
- Accel (US/UK)
- a]6z (US)

### Angel Scene
- Business Angels Netzwerk Deutschland (BAND)
- Angels active on LinkedIn
- Ex-founder angels common

## Funding Path

### Typical Berlin Startup Journey

| Stage | Amount | Sources |
|-------|--------|---------|
| Pre-seed | €50-250K | Angels, accelerators, grants |
| Seed | €500K-2M | Seed VCs, angels |
| Series A | €5-15M | Multi-stage VCs |
| Series B+ | €20M+ | Growth VCs |

### Grants Available

**EXIST Gründerstipendium**
- For university spinoffs
- €1,000-3,000/month per founder
- Up to €30,000 for materials
- Duration: 12 months

**Berlin Startup Stipendium**
- €1,500/month per founder
- 6 months
- Based in Berlin
- Early-stage focus

**EU Funding**
- EIC Accelerator
- Horizon Europe grants
- Complex but large amounts

### Government Support
- **KfW loans**: Low-interest startup loans
- **Investitionsbank Berlin**: Regional funding
- **BAFA**: Innovation grants

## Legal Structure for Startups

### Most Common Path
1. **Start as Freiberufler/UG**: Validate idea
2. **Convert to GmbH**: Before raising VC (VCs prefer GmbH)
3. **Consider Holding**: Tax optimization

### Investor Requirements
- GmbH strongly preferred
- Clean cap table
- Proper documentation
- German or DE subsidiary

### Legal Costs
- GmbH formation: €2,000-5,000
- First financing round legal: €10,000-30,000
- Ongoing: €500-2,000/month

## Building a Team

### Where to Hire
| Platform | Best For |
|----------|----------|
| LinkedIn | Senior roles |
| Honeypot | Tech talent |
| Berlin Startup Jobs | Startup-minded |
| AngelList | Early employees |
| Universities | Interns, juniors |

### Salary Expectations (Startup)
- **Junior dev**: €45,000-55,000 + equity
- **Senior dev**: €70,000-90,000 + equity
- **Product Manager**: €60,000-80,000 + equity
- **Early employee**: Lower cash, more equity

### ESOP (Employee Options)
- Standard: 10-15% pool
- Vesting: 4 years, 1-year cliff
- German tax: Complex, improving
- Legal setup: €3,000-10,000

## Startup Hubs & Community

### Coworking
| Space | Monthly | Vibe |
|-------|---------|------|
| Factory Berlin | €400-600 | Premium, networking |
| Betahaus | €200-350 | Creative, established |
| Mindspace | €350-500 | Corporate-ready |
| Rent24 | €300-400 | Affordable |
| St. Oberholz | Free (cafe) | Classic Berlin |

### Events
- **Tech Open Air**: Annual conference
- **Startup Safary**: Office crawl
- **hy Berlin**: Axel Springer event
- **Pirate Summit**: (Cologne but relevant)
- **Meetups**: Many weekly

### Communities
- Silicon Allee
- Berlin Founders
- Various Slack groups
- LinkedIn groups

## Common Mistakes

1. **Raising too early**: Validate before fundraising
2. **Wrong structure**: GmbH before VC, not after
3. **Ignoring bureaucracy**: Budget time for admin
4. **English-only**: Some German admin unavoidable
5. **Underestimating costs**: Add 30% buffer
6. **Isolation**: Join community early
7. **Wrong VC**: Research fund focus
8. **No German accountant**: Get one from day 1
