# Berlin Safety & Laws

## Safety Overview

Berlin is one of Europe's safest capitals. Violent crime is rare.

### Crime Reality
| Type | Level | Notes |
|------|-------|-------|
| Violent crime | Very low | Rare, mostly domestic |
| Pickpocketing | Moderate | Tourist spots, transit |
| Bike theft | High | Very common, lock well |
| Burglary | Moderate | Ground floor apartments |
| Scams | Moderate | Tourist areas |

### Safe Areas
Almost all of Berlin is safe day and night. No "no-go zones" like media sometimes claims.

### Areas Requiring Awareness
- **Alexanderplatz** (late night): Drunk people, occasional fights
- **Görlitzer Park** (Kreuzberg): Drug dealing, fine during day
- **Kottbusser Tor**: Can feel sketchy, mostly fine
- **Warschauer Straße** (late night): Drunk tourists, pickpockets

### Night Safety
- Public transit runs all night Fri-Sat
- Well-lit major streets
- Women generally feel safe
- Standard precautions apply

## Common Scams

### Tourist Scams
- **Petition signers**: Distraction for pickpocketing
- **CD sellers**: Aggressive, overpriced
- **Fake monks**: Asking for "donations"
- **Broken taxi meter**: Insist on meter or agree price upfront
- **Apartment scams**: See resident.md

### How to Avoid
- Don't engage with street approaches
- Keep valuables in front pockets/bags
- Be aware in crowded transit
- Trust your instincts

## Laws to Know

### Drugs
- **Cannabis**: Legal for adults since 2024 (possession, not public consumption everywhere)
- **Public smoking**: Allowed in some areas, check local rules
- **Other drugs**: Illegal, but Berlin police often tolerant for personal use
- **Clubs**: May have stricter no-photo policies, not drug checks
- **Reality**: Berlin is tolerant, but don't push limits

### Alcohol
- **Legal age**: 16 for beer/wine, 18 for spirits
- **Public drinking**: Legal and common (Späti culture)
- **Transit drinking**: Technically banned on some lines, rarely enforced
- **Drunk driving**: Very strict, 0.5‰ limit (0.0‰ for new drivers)

### Traffic
- **Jaywalking**: Technically illegal (€5-10 fine), rarely enforced
- **Exception**: Germans wait at red lights, especially with children present
- **Cycling**: Bike lanes mandatory where they exist
- **E-scooters**: Same rules as bikes, illegal on sidewalks

### Photography
- **GDPR applies**: Can't photograph people without consent
- **Street photography**: Gray area, be respectful
- **Children**: Never photograph other people's children
- **Private property**: Ask permission

### Noise
- **Quiet hours**: 10pm-6am and all day Sunday
- **Neighbors**: Will complain, landlords take seriously
- **Music**: Keep it down, use headphones late
- **Construction**: Allowed Mon-Sat 7am-8pm only

### Recycling
- **Pfand**: Bottle deposit system
  - €0.25: Plastic bottles, cans
  - €0.08: Reusable glass bottles
  - Return at supermarket machines
- **Bins**: Yellow (packaging), Blue (paper), Brown (bio), Black (rest)
- **Fines**: Possible for wrong disposal, rarely enforced

### Renting
- **Mietpreisbremse**: Rent control (complex, often violated)
- **Tenant rights**: Very strong in Germany
- **Deposit**: Max 3× Kaltmiete, must be returned with interest
- **Notice period**: 3 months standard

## Emergency Contacts

| Service | Number |
|---------|--------|
| Police | 110 |
| Fire/Ambulance | 112 |
| Poison control | 030 19240 |
| Women's crisis | 030 611 03 00 |
| LGBTQ+ crisis | 030 216 33 36 |

### Police Interaction
- Generally professional
- English often spoken
- For theft reports: Go to station (needed for insurance)
- Non-emergency: 030 4664 4664

### Healthcare Emergency
- **Notaufnahme**: Hospital emergency room
- **Ärztlicher Bereitschaftsdienst**: 116 117 (after-hours doctor)
- **Pharmacy emergency**: Rotating Notapotheken (check online)

## Insurance

### Required
- **Health insurance**: Mandatory for all residents
- **Car insurance**: Mandatory if you own a car

### Recommended
- **Liability (Haftpflichtversicherung)**: €5-10/month, covers damages you cause
- **Household (Hausratversicherung)**: Covers your belongings
- **Legal (Rechtsschutzversicherung)**: For legal disputes

## Political Demonstrations

- **Very common**: Berlin has many protests
- **Usually peaceful**: May block traffic
- **1 May**: Traditional protest day, Kreuzberg can get rowdy
- **How to handle**: Check news, avoid if uncomfortable, generally safe to observe
