# Moving to Berlin Guide

## First Steps (In Order)

### 1. Anmeldung (Address Registration)
**CRITICAL**: Must register within 14 days of moving in.

**What you need**:
- Passport/ID
- Wohnungsgeberbestätigung (landlord confirmation form)
- Completed Anmeldung form

**Where**: Bürgeramt (citizen's office) - any district

**How to book**:
- Online: service.berlin.de (often no appointments available)
- Walk-in: Early morning, arrive 30 min before opening
- Hack: Check cancellations daily, try outer districts

**Why critical**: Required for EVERYTHING - bank account, phone contract, tax ID, health insurance.

### 2. Bank Account
**Options**:
| Bank | Type | Requirements | Notes |
|------|------|--------------|-------|
| N26 | Digital | Passport + address | Fast, English |
| Revolut | Digital | Passport | International friendly |
| DKB | Traditional | Anmeldung + German skills | Free ATM worldwide |
| Commerzbank | Traditional | Anmeldung | Physical branches |
| Sparkasse | Traditional | Anmeldung | Local, bureaucratic |

**Recommendation**: N26 or Revolut immediately, German bank later if needed.

### 3. Tax ID (Steuer-ID)
- Automatically sent after Anmeldung (2-4 weeks)
- 11-digit number, keep forever
- Required for employment

### 4. Health Insurance
**Mandatory** for all residents.

| Type | Who | Cost | Notes |
|------|-----|------|-------|
| Public (GKV) | Most employees | ~15% salary | TK, AOK, Barmer |
| Private (PKV) | High earners (€69,300+) | Varies | Better coverage, complex |
| Expat insurance | Short-term | €60-200/mo | Temporary only |

**Recommendation**: Public insurance (TK or Barmer) for most. Private only if planning long-term, young, healthy.

### 5. Phone/Internet
**SIM options**:
- **Prepaid**: Aldi Talk, Lidl Connect (€10-20/mo)
- **Contract**: O2, Vodafone, Telekom (€20-40/mo)
- **Note**: Need Anmeldung for contracts

**Home internet**:
- 3-6 week installation wait typical
- 2-year contracts standard
- Options: Vodafone, 1&1, Telekom

## Finding an Apartment

### Reality Check
Berlin housing market is BRUTAL. Expect:
- 30-100 applicants per apartment
- 2-3 months searching
- Possible rejection for being foreign/new
- Scams targeting newcomers

### Where to Search
| Platform | Type | Notes |
|----------|------|-------|
| Immobilienscout24 | Main market | Most listings, highest competition |
| WG-Gesucht | Shared flats | Good for starting out |
| eBay Kleinanzeigen | Mixed | Some gems, some scams |
| Facebook Groups | Informal | Berlin Apartments, sublets |
| Spotahome | Furnished | Higher prices, easier process |

### Documents to Prepare
1. **Schufa Auskunft** - Credit report (order from meineschufa.de, €30)
2. **Mietschuldenfreiheitsbescheinigung** - Previous landlord reference
3. **Employment contract** or proof of income
4. **Last 3 payslips**
5. **ID/Passport copy**
6. **Personal introduction** (Bewerbungsschreiben)

### What to Expect
- **Kaltmiete**: Base rent
- **Nebenkosten**: Utilities (heating, water, trash)
- **Warmmiete**: Total = Kalt + Nebenkosten
- **Kaution**: Deposit (max 3x Kaltmiete)
- **Provision**: Agent fee (usually paid by landlord now)

### Red Flags (Scams)
- Apartment abroad, can't show it
- Payment before viewing
- Too good to be true price
- Pressure to decide immediately
- Wire transfer to foreign account

### WG (Shared Apartment) Strategy
Often easier than solo apartments:
1. Create profile on WG-Gesucht
2. Write personal, specific messages
3. Be flexible on dates
4. Show personality in viewings
5. Offer 6+ month commitment

## Integration Steps

### German Language
- **A1-B1**: Volkshochschule (affordable, €100-200/course)
- **Intensive**: Goethe Institut (expensive, quality)
- **Free**: Tandem partners, language exchanges
- **Apps**: Duolingo, Babbel

### Integration Course
- For non-EU with residence permit
- 600 hours German + 100 hours civic
- Often mandatory, subsidized

### Social Integration
- **Meetup.com**: Many English/international groups
- **Sports**: Join a Verein (club)
- **Neighbors**: Say "Hallo", Germans warm up slowly
- **Work**: Often best social entry point

## Long-Term Residency

### Niederlassungserlaubnis (Permanent Residence)
After 5 years of legal residence:
- German B1 level
- Self-sufficient (no welfare)
- Pension contributions
- 60 months of contributions

### German Citizenship
After 8 years (reduced paths exist):
- German B1 level
- Pass citizenship test
- Renounce previous citizenship (some exceptions)
- No criminal record
