# Berlin Local Services Guide

## Anmeldung (Address Registration)

**CRITICAL**: Must register within 14 days of moving.

### What You Need
1. Passport/ID
2. Completed Anmeldeformular (registration form)
3. Wohnungsgeberbestätigung (landlord confirmation)

### Where to Go
- Any Bürgeramt (citizen's office) in any district
- Book online: service.berlin.de (slots scarce)
- Walk-in: Arrive 30 min before opening

### Tips
- Outer district offices have more availability
- Check cancellations daily
- Bring all documents even if not required
- Get multiple Meldebescheinigung copies (€5 each)

### Why It Matters
Required for:
- Bank accounts
- Employment
- Phone contracts
- Tax ID (automatic after)
- Health insurance
- Everything official

## Banking

### Recommended Banks

| Bank | Type | Pros | Cons |
|------|------|------|------|
| N26 | Digital | Fast setup, English app | No cash deposits |
| Revolut | Digital | Multi-currency | Not German bank |
| DKB | Online | Free worldwide ATM | German only |
| ING | Online | Good overdraft | German heavy |
| Commerzbank | Traditional | Branches | Fees |

### Opening Account
- **Digital (N26/Revolut)**: Video ID, minutes to open
- **Traditional**: Anmeldung required, appointment needed

### SCHUFA
- German credit score system
- Built over time with German financial history
- Can check your score: meineschufa.de (€30)
- Important for: renting, phone contracts, loans

## Health Insurance

### Types

**Public (Gesetzliche - GKV)**
- Most common
- ~15% of salary (split with employer)
- Covers: family, basics, extensive
- Providers: TK, AOK, Barmer, DAK

**Private (Private - PKV)**
- For employees earning >€69,300/year or self-employed
- Varies by age, health, coverage
- Better coverage, faster appointments
- Cannot easily switch back to public

### Recommendation
- Employees: Public (TK is popular)
- Freelancers: Either, depends on age/health
- Short-term: Expat insurance (temporary only)

### Doctors
- **Hausarzt**: General practitioner (register with one)
- **Facharzt**: Specialists (need referral usually)
- **Doctolib**: App for booking appointments
- **Waiting**: Can be weeks for specialists

## Phone & Internet

### Mobile Providers
| Provider | Network | Price Range |
|----------|---------|-------------|
| Telekom | Best coverage | €30-50/mo |
| Vodafone | Good coverage | €25-45/mo |
| O2 | Budget option | €15-35/mo |
| Aldi Talk | Prepaid | €10-15/mo |
| Lidl Connect | Prepaid | €10-15/mo |

### SIM Card
- Prepaid: Buy at supermarket, register online
- Contract: Needs Anmeldung, 24-month terms common
- eSIM: Available from most providers

### Home Internet
| Provider | Speed | Price |
|----------|-------|-------|
| Telekom | Up to 250 Mbps | €40-50/mo |
| Vodafone | Up to 1 Gbps (cable) | €40-50/mo |
| 1&1 | Up to 250 Mbps | €30-45/mo |
| O2 | Up to 100 Mbps | €30-40/mo |

**Warning**: 
- Installation takes 2-6 weeks
- 24-month contracts standard
- Check coverage at your address first

## Post & Packages

### Deutsche Post / DHL
- Yellow mailboxes everywhere
- Track packages: dhl.de
- Packstation: 24/7 lockers (free, register online)

### Package Delivery
- DHL most common
- Hermes, DPD, UPS also used
- Neighbors often accept (Nachbar)
- Packstation recommended for reliability

## Utilities

### Electricity
- Choose provider (Vattenfall default)
- Green options: Naturstrom, Lichtblick
- Switch online, easy
- ~€40-80/month

### Gas
- If not included in rent
- GASAG default in Berlin
- ~€30-70/month

### Water
- Usually in Nebenkosten
- Berliner Wasserbetriebe

## Recycling & Waste

### Pfand System
- Return bottles for deposit
- Plastic bottles/cans: €0.25
- Reusable glass: €0.08
- Machines at supermarkets

### Trash Separation
| Bin | Contents |
|-----|----------|
| Yellow | Packaging (plastic, cans, cartons) |
| Blue | Paper, cardboard |
| Brown | Organic waste |
| Black | Residual waste |
| Glass | Bottles (no Pfand), jars - separate by color |

### Bulky Items
- Sperrmüll pickup: Schedule with BSR
- Or: Leave on street (Berliners take what they want)

## GEZ / Rundfunkbeitrag

- **What**: TV/radio tax
- **Cost**: €18.36/month
- **Who pays**: One per household
- **Mandatory**: Yes, even without TV
- **Register**: rundfunkbeitrag.de (they'll find you anyway)

## Useful Apps

| App | Purpose |
|-----|---------|
| BVG | Transit tickets & times |
| Doctolib | Book doctor appointments |
| eBay Kleinanzeigen | Buy/sell used items |
| Lieferando | Food delivery |
| PayPal | Payments |
| service.berlin.de | Government appointments |
| WG-Gesucht | Find housing |
