# Berlin Healthcare Guide

## System Overview

Germany has universal healthcare. Two types:

| Type | Public (GKV) | Private (PKV) |
|------|--------------|---------------|
| Who | Most employees | High earners, self-employed |
| Cost | % of salary (~15%) | Fixed premium |
| Coverage | Standardized | Customizable |
| Family | Free coverage | Pay per person |
| Doctors | Some restrictions | Usually better access |

## Public Insurance (GKV)

### Main Providers
| Provider | Notes |
|----------|-------|
| TK (Techniker) | Popular, good service |
| AOK | Regional, established |
| Barmer | Large, comprehensive |
| DAK | Good online tools |
| HKK | Lower contributions |

### Cost
- ~15.5% of gross salary (employee pays ~7.75%)
- Capped at €4,987.50/month salary basis
- Family coverage included (spouse, children)

### Coverage
- GP visits
- Specialists (some waiting)
- Hospital stays
- Prescriptions (small copay)
- Mental health (some limits)
- Dental basics
- Pregnancy/childbirth
- Preventive care

### Limitations
- Waiting times for specialists
- Basic dental only
- Limited alternative medicine
- Semi-private hospital rooms

## Private Insurance (PKV)

### Who Qualifies
- Employees earning >€69,300/year
- Self-employed (any income)
- Civil servants

### Cost Factors
- Age at entry
- Health status
- Coverage level
- Chosen deductible

### Typical Costs
- Young, healthy: €250-400/month
- 40+: €400-700/month
- Increases with age

### Advantages
- Shorter waiting times
- Private rooms
- Better dental
- Alternative medicine
- Faster appointments

### Disadvantages
- Must pay upfront, get reimbursed
- Costs increase with age
- Hard to switch back to public
- Family must pay separately

## Finding a Doctor

### Hausarzt (GP)
- Register with one
- First point of contact
- Referrals to specialists
- Search: Jameda, Google, DocInsider

### Facharzt (Specialists)
- Usually need referral
- Long waits possible (weeks)
- Tip: Call multiple, mention urgency

### Booking Appointments
| Method | Details |
|--------|---------|
| Doctolib | App, many doctors |
| Direct call | Still common |
| Walk-in | Hausarzt sometimes |
| 116 117 | Emergency appointments |

### Emergency Care
- **Notaufnahme**: Hospital emergency room
- **116 117**: Non-emergency doctor service
- **112**: Ambulance

## Pharmacies (Apotheken)

### Prescriptions
- Doctor writes prescription
- Take to any Apotheke
- Some copay (€5-10 typical)
- Prescription valid 3 months

### Over-the-Counter
- Many medications prescription-only in Germany
- Ibuprofen, paracetamol: OTC
- Stronger painkillers: Prescription
- Pharmacist can advise

### Emergency Pharmacies
- Rotating night/weekend service (Notapotheke)
- Check: apotheken.de
- Higher fees apply

## Dental Care

### Public Insurance Coverage
- Basic checkups
- Emergency treatment
- Fillings (basic materials)
- X-rays

### Not Covered (Public)
- Cosmetic work
- Implants
- Premium materials
- Comprehensive cleaning

### Recommendation
- Zahnzusatzversicherung (dental add-on insurance)
- €15-50/month
- Covers implants, better materials

## Mental Health

### Coverage
- Included in both public/private
- Waiting lists can be long (months)

### Finding Help
- Psychotherapeuten: Long-term therapy
- Psychiater: Medication focus
- Search: Psychotherapiesuche.de
- Apps: Selfapy, HelloBetter (some covered)

### Tips
- Start searching early
- Call multiple therapists
- Ask about cancellation lists
- English-speaking therapists exist

## Having a Baby

### Prenatal Care
- Free with insurance
- Regular Frauenarzt checkups
- Hospital birth standard
- Midwife (Hebamme) recommended

### Parental Leave (Elternzeit)
- Up to 3 years per parent
- Elterngeld: 65-67% of salary (12-14 months)
- Job protected

### Childcare (Kita)
- Apply early (waitlists!)
- Free after age 1 (Berlin)
- Kita-Navigator: Online application

## Vaccinations

### Required
- None for adults (some for children in daycare)

### Recommended
- COVID boosters
- Flu (annual)
- FSME (tick-borne, if outdoor activities)

### Where
- Hausarzt
- Health department (some free)
- Pharmacies (limited)

## Health Essentials

### First Things to Do
1. Register for health insurance
2. Find a Hausarzt
3. Get EHIC card (for EU travel)
4. Know nearest hospital

### Useful German
| German | English |
|--------|---------|
| Krankenversicherung | Health insurance |
| Arzt | Doctor |
| Rezept | Prescription |
| Überweisung | Referral |
| Krankschreibung | Sick note |
| Notfall | Emergency |
