# Berlin Food Practical Guide

## Dietary Requirements

### Vegetarian
Berlin is excellent for vegetarians:
- **Restaurants**: Cookies Cream (fine dining), Lucky Leek, Kopps
- **Casual**: Most restaurants have options
- **Döner**: Gemüse (vegetable) döner widely available
- **Note**: German menus may have limited veggie options

### Vegan
Berlin is Europe's vegan capital:
- **Fine dining**: Cookies Cream, Lucky Leek
- **Casual**: 1990 Vegan Living, Vöner (vegan döner)
- **Burgers**: Swing Kitchen, Vincent Vegan
- **Apps**: HappyCow lists 400+ vegan spots
- **Supermarkets**: Veganz (dedicated vegan), all majors have sections

### Halal
Large Muslim population = easy access:
- **Areas**: Kreuzberg, Neukölln, Wedding have many options
- **Turkish/Arabic**: Most are halal
- **Ask**: "Ist das Halal?" (Is this halal?)
- **Delivery apps**: Filter by halal available

### Kosher
Limited but available:
- **Area**: Jewish community in Mitte
- **Restaurants**: Beth Café (Joachimstaler Str), Bleibergs
- **Supermarkets**: Few kosher sections, import shops

### Gluten-Free
Improving options:
- **Bakeries**: Jute Bäckerei, Zeit für Brot has options
- **Restaurants**: Most accommodate with advance notice
- **Note**: Ask specifically - cross-contamination common
- **Phrase**: "Ich habe eine Glutenunverträglichkeit" (I have gluten intolerance)

### Allergies
- **Phrase**: "Ich bin allergisch gegen..." (I'm allergic to...)
- **Common**: Nüsse (nuts), Milch (dairy), Eier (eggs)
- **By law**: Allergen information must be available

## Alcohol Culture

### Beer
- **Types**: Pilsner (standard), Weißbier (wheat), Berliner Weisse (sour, summer)
- **Local brands**: Berliner Kindl, Berliner Pilsner
- **Craft**: Many local breweries (BRLO, Vagabund, Stone)
- **Price**: €3-4 restaurant, €1-2 Späti

### Wine
- **Scene**: Natural wine explosion
- **Wine bars**: Freundschaft, Cordobar, Weinerei
- **German wine**: Riesling, Spätburgunder (Pinot Noir)
- **Price**: €6-10/glass restaurant

### Späti Culture
- **What**: Late-night corner shops (Spätkauf)
- **Open**: 24/7 in most areas
- **Culture**: Buy beer, sit outside, socialize
- **Price**: €1-2 for beer, much cheaper than bars
- **Note**: Very Berlin tradition

### Bars vs Clubs
- **Bars**: Open late (3-4am often)
- **Clubs**: Start after midnight, run until afternoon
- **Club culture**: Not about drinking, about dancing

### Legal Notes
- **Drinking age**: 16 for beer/wine, 18 for spirits
- **Public drinking**: Legal and common
- **Drunk driving**: Zero tolerance (0.3‰ for accidents)

## Supermarkets & Shopping

### Supermarket Tiers
| Store | Quality | Price | Notes |
|-------|---------|-------|-------|
| Aldi/Lidl | Basic | € | Budget, limited organic |
| Rewe | Good | €€ | Wide selection |
| Edeka | Good-Excellent | €€-€€€ | Varies by location |
| Bio Company | Organic | €€€ | All organic |
| Alnatura | Organic | €€€ | German organic chain |
| KaDeWe Food Hall | Premium | €€€€ | Department store, specialty |

### Opening Hours
- **Weekdays**: 7am-10pm (most)
- **Saturday**: 7am-10pm
- **Sunday**: CLOSED (most groceries)
- **Exception**: Some Späti-style shops, train station shops

### Specialty Shops
- **Asian**: Go Asia, Dong Xuan Center
- **Turkish**: Many in Kreuzberg/Wedding
- **Organic markets**: Various neighborhoods
- **Zero waste**: Original Unverpackt

## Delivery & Apps

### Food Delivery
| App | Coverage | Notes |
|-----|----------|-------|
| Lieferando | Best coverage | Most restaurants |
| Wolt | Good in central | Better quality focus |
| Uber Eats | Decent | Standard chains |
| Gorillas/Flink | Groceries | Quick delivery (RIP Gorillas, merged) |

### Tips
- Delivery fees: €1-3
- Minimum order: Often €10-15
- Peak times: Surge pricing possible
- Cash option: Usually available

## Reservations & Timing

### When to Book
- **Casual lunch**: No need
- **Casual dinner (Mon-Wed)**: Usually fine
- **Thursday-Saturday dinner**: Book 3-7 days ahead
- **Sunday brunch**: Always book
- **Fine dining**: 2-4 weeks ahead

### Apps for Booking
- **Resy**: Fine dining
- **TheFork**: European, often discounts
- **Google Maps**: Direct restaurant contact
- **Instagram**: Many restaurants take DM bookings

### German Dining Times
- **Lunch**: 12-2pm (kitchen often closes 2:30)
- **Dinner**: 6:30-9pm (Germans eat early)
- **Late dining**: 9pm+ harder to book, but possible
- **Kitchen closing**: Often 10pm weeknights, 10:30-11pm weekends
