# Berlin Food Culture

## Overview

Berlin is Germany's most diverse food city, but NOT a traditional German food destination. The city's food identity is:

- **Multicultural**: 190+ nationalities = incredible variety
- **Street food capital**: Döner kebab is more Berlin than schnitzel
- **Brunch obsessed**: Weekend institution
- **Late-night friendly**: Spätis and döner 24/7
- **Wine bar renaissance**: Natural wine scene thriving
- **Budget-friendly**: Great eating at all price points

## Quick Food Map

| Cuisine | Where to Go |
|---------|-------------|
| **Turkish/Döner** | Kreuzberg (36), Wedding |
| **Vietnamese** | Mitte (Rosenthaler), Charlottenburg |
| **Middle Eastern** | Neukölln, Kreuzberg |
| **Italian** | Neukölln, Prenzlauer Berg |
| **Asian mix** | Kantstraße (Charlottenburg) |
| **German traditional** | Charlottenburg, Mitte (touristy) |
| **Fine dining** | Mitte, Tiergarten area |
| **Brunch** | Prenzlauer Berg, Kreuzberg |
| **Street food** | Markthalle Neun, markets |

## Berlin Food Icons

### Döner Kebab
- **Origin story**: Modern döner invented in Berlin (1970s, Turkish immigrants)
- **Style**: Bread options - Fladenbrot, Dürüm, or half bread
- **Fillings**: Kalb (veal) or Hähnchen (chicken), salad, sauce
- **Classic order**: "Mit alles und scharf" (with everything and spicy)
- **Best**: Rüyam Gemüse Kebab, Mustafa's (queue), Imren
- **Cost**: €6-8

### Currywurst
- **Origin**: Berlin, 1949
- **What**: Sliced pork sausage, curry ketchup, curry powder
- **Classic**: With/ohne Darm (with/without skin)
- **Best**: Konnopke's (Prenzlauer Berg), Curry 36 (Kreuzberg)
- **Cost**: €4-5

### Berliner Pfannkuchen (Berliner)
- **What**: Jelly-filled donut (called Pfannkuchen in Berlin)
- **Note**: Germans elsewhere call it "Berliner"
- **Best**: Traditional bakeries, not chains

## Food Hall Culture

### Markthalle Neun (Kreuzberg)
- **When**: Thursday 5-10pm (Street Food Thursday)
- **What**: 40+ vendors, rotating concepts
- **Vibe**: Crowded, loud, foodie heaven
- **Tip**: Go early (5pm) to avoid worst crowds

### Arminiusmarkthalle (Moabit)
- **When**: Daily
- **What**: Traditional market hall, diverse stalls
- **Vibe**: Less touristy than Markthalle Neun

### Marheineke Markthalle (Kreuzberg)
- **When**: Daily
- **What**: More upscale food hall
- **Good for**: Lunch, quality ingredients

## Markets

### Turkish Market (Maybachufer)
- **When**: Tuesday & Friday, 11am-6:30pm
- **What**: Turkish produce, bread, olives, cheese
- **Must-try**: Gözleme (filled flatbread)

### Winterfeldtmarkt (Schöneberg)
- **When**: Wednesday & Saturday
- **What**: Organic produce, flowers, food stalls
- **Vibe**: Popular brunch spot

### Kollwitzmarkt (Prenzlauer Berg)
- **When**: Saturday
- **What**: Organic farmers market
- **Vibe**: Families, upscale

## Price Ranges

| Category | Example | Price |
|----------|---------|-------|
| Street food | Döner, falafel | €5-8 |
| Späti snack | Sandwich, beer | €3-5 |
| Casual lunch | Soup, salad, main | €10-15 |
| Dinner (casual) | Main + drink | €20-35 |
| Dinner (nice) | Full meal | €40-70 |
| Fine dining | Tasting menu | €100-200 |
| Brunch | Weekend buffet | €15-25 |

## Tipping

- **Restaurants**: 5-10% (round up or add a few euros)
- **Bars**: Round up (€4.40 → €5)
- **Delivery**: €1-2
- **Note**: Not as expected as US, but appreciated

## Reservations

- **Thursday-Saturday dinner**: Book 1+ week ahead
- **Sunday brunch**: Book or expect 30+ min wait
- **Fine dining**: 2-4 weeks ahead
- **Casual lunch**: Usually not needed

## Dietary Notes

- **Vegetarian**: Excellent options everywhere
- **Vegan**: Berlin is vegan paradise
- **Halal**: Widely available (Kreuzberg, Neukölln, Wedding)
- **Gluten-free**: Many options, ask specifically
- **Kosher**: Limited, mainly in Mitte (Jewish community)
