# Berlin Education Guide

## For Children

### Kita (Daycare) - Ages 1-6

**Cost**: Free in Berlin (since 2018, meals extra ~€23/month)

**Types**:
- Public (kommunale Kita)
- Private (freie Träger)
- Parent-initiative (Elterninitiative)

**Finding a Spot**:
1. Register at Kita-Navigator (service.berlin.de)
2. Apply to multiple (5-10)
3. Start 1+ year before needed
4. Visit Kitas personally

**Waiting Lists**: Notorious. Start early!

**Language**: German primarily. Some bilingual options.

### Primary School (Grundschule) - Ages 6-12

**Duration**: 6 years in Berlin

**Types**:
- Public (free)
- Private (€100-600/month)
- International (see below)

**Catchment Areas**: Usually assigned by address

**Languages**: German. English from grade 3.

### Secondary School - Ages 12-18

**Types**:
| School | Path | Notes |
|--------|------|-------|
| Gymnasium | Academic | University track |
| Sekundarschule | Comprehensive | Multiple paths |
| Gesamtschule | Integrated | All levels |

**Abitur**: University entrance qualification (age 18-19)

### International Schools

**English-Language Options**:
| School | Fees/Year | Notes |
|--------|-----------|-------|
| Berlin International School | €15,000-20,000 | IB program |
| Berlin British School | €18,000-22,000 | British curriculum |
| John F. Kennedy School | Free (public) | German-American, waitlist |
| Berlin Cosmopolitan School | €5,000-8,000 | State-accredited |
| Berlin Metropolitan School | €12,000-18,000 | IB World School |
| Phorms | €5,000-12,000 | German-English |

**Notes**:
- JFK School: Free but extreme demand
- Most require early application
- Consider German integration

### Bilingual Programs

**Europa-Schulen**: 
- Public bilingual schools
- German + English/French/Spanish/etc.
- Free but competitive
- Integration advantage

## For Adults

### German Language

**Levels** (CEFR):
- A1-A2: Beginner
- B1-B2: Intermediate (B1 for citizenship)
- C1-C2: Advanced

**Options**:
| Provider | Cost | Notes |
|----------|------|-------|
| Volkshochschule (VHS) | €100-200/course | Affordable, quality |
| Goethe Institut | €1,000+/level | Premium, intensive |
| Deutsche Welle | Free | Online courses |
| Tandem partners | Free | Language exchange |
| Private tutors | €20-50/hour | Flexible |

**Integration Course**:
- 600 hours German + 100 hours civic
- Subsidized for immigrants
- Often mandatory for residence

### University

**Public Universities** (Free!):
- Humboldt Universität (HU)
- Freie Universität (FU)
- Technische Universität (TU)
- Semester fee only: ~€300-350

**Requirements**:
- Recognized degree/Abitur
- German proficiency (most programs)
- Some English programs available

**English-Taught Programs**:
- MBA programs
- Some Master's degrees
- International programs

**Private Universities**:
| University | Focus | Cost |
|------------|-------|------|
| ESMT Berlin | Business | €40,000+ |
| Hertie School | Policy | €20,000/year |
| Code University | Tech | Deferred tuition |
| UE Berlin | Various | €10,000/year |

### Professional Education

**Ausbildung** (Vocational Training):
- 2-3 years dual system
- Paid position
- Common in trades, business

**Weiterbildung** (Continuing Education):
- IHK courses
- Online certifications
- Company training

**Tech Bootcamps**:
| Program | Duration | Cost |
|---------|----------|------|
| Ironhack | 9 weeks | €7,500 |
| Le Wagon | 9 weeks | €6,900 |
| Spiced Academy | 12 weeks | €8,500 |
| Neue Fische | 12 weeks | €8,400 |

## Important Notes

### School System Complexity
- German system is tracked (different paths)
- International students may need assessment
- Grade conversion: Ask school directly
- School year: August/September start

### Childcare Crisis
- Berlin has Kita shortage
- Start process immediately upon arrival
- Consider Tagesmutter (childminder) as backup
- Some employers help with placement

### Language Reality
- German essential for integration
- English schools create bubble
- Consider long-term plans
- Bilingual best of both worlds

### Documents Needed
- Birth certificate (translated)
- Previous school records
- Vaccination records
- Residence registration
- Health insurance proof
