# Berlin Cycling & Mobility Guide

## Cycling Overview

Berlin is a cycling city. Flat terrain, extensive infrastructure, and bike-friendly culture make it ideal.

### Quick Stats
- **Bike trips**: 18% of all trips (rising)
- **Bike lanes**: 1,000+ km
- **Bike parking**: Expanding, still limited
- **Weather**: Year-round possible (winter needs prep)

## Infrastructure

### Bike Lanes
- **Protected lanes**: Increasing (green paint, barriers)
- **Street lanes**: Common, varies in quality
- **Shared paths**: Parks, canals
- **Quality**: Improving but inconsistent

### Best Routes
| Route | Description |
|-------|-------------|
| Canal paths | Flat, car-free, scenic |
| Tiergarten | Through central park |
| Tempelhof | Massive car-free area |
| Mauerweg | Berlin Wall path (160km) |
| Spree riverside | East-west corridor |

### Challenging Areas
- Alexanderplatz (crowded)
- Ku'damm (traffic)
- Some outer districts (gaps)

## Getting a Bike

### Buying New
| Store | Price Range | Notes |
|-------|-------------|-------|
| Decathlon | €200-800 | Budget, reliable |
| Stadler | €300-2,000 | Large selection |
| Fahrrad.de | €400+ | Online, delivered |
| Local shops | €400+ | Service included |

### Buying Used
| Source | Notes |
|--------|-------|
| eBay Kleinanzeigen | Most options |
| Facebook Marketplace | Popular |
| Fahrrad Herz | Quality used |
| Police auctions | Cheap, irregular |

### Price Guide (Used)
- Basic city bike: €100-200
- Good quality: €200-400
- Premium: €400-800+

### What to Get
**City bike essentials**:
- Lights (front + rear) - legally required
- Fenders (Berlin is wet)
- Rack/basket (practical)
- Good lock (essential)
- Bell (legally required)

## Bike Sharing

| Service | Type | Cost |
|---------|------|------|
| Nextbike | Docked | €1/15min, €12/day |
| Lime | Dockless | Unlock + €0.20/min |
| Bolt | E-bikes | Unlock + per min |
| Donkey Republic | App-based | €1/hour |

### E-Scooter
- Same rules as bikes
- Illegal on sidewalks
- Must use bike lanes
- Lime, Tier, Bolt available

## Security

### Lock Strategy
**Essential**: Berlin has HIGH bike theft

1. **Two different locks**: U-lock + chain
2. **Lock frame AND wheel**
3. **Lock to fixed object**
4. **Don't leave overnight outside**
5. **Register bike**: Berlin Polizei, Fahrradcodierung

### Lock Types
| Type | Security | Price |
|------|----------|-------|
| U-lock (Kryptonite/Abus) | High | €40-100 |
| Heavy chain | High | €50-100 |
| Folding lock | Medium-High | €60-120 |
| Cable lock | Low | €15-30 |

**Minimum**: U-lock + cable. Better: U-lock + heavy chain.

### If Stolen
1. Report to police (online possible)
2. Claim on household insurance
3. Check eBay Kleinanzeigen (sometimes listed)

## Rules of the Road

### Legal Requirements
- **Lights**: Front (white) + rear (red)
- **Reflectors**: Front, rear, pedals, wheels
- **Bell**: Must have one
- **Brakes**: Must work

### Traffic Rules
- **Bike lanes**: Must use when marked
- **Red lights**: Must stop (€60-180 fine)
- **One-way streets**: Unless marked for bikes
- **Right of way**: Same as cars
- **Phone use**: Illegal while cycling

### Common Fines
| Violation | Fine |
|-----------|------|
| Red light | €60-180 |
| No lights | €20-35 |
| Wrong way | €20-35 |
| Phone use | €55 |
| No bell | €15 |

## Winter Cycling

### Preparation
- **Tires**: Consider studded for ice
- **Lights**: Even more important (darkness)
- **Clothing**: Layers, visibility
- **Maintenance**: Salt corrodes, clean regularly

### Reality
- Many cycle year-round
- December-February hardest
- Ice patches dangerous
- Some choose transit for worst days

## Bikes + Transit

### Allowed
- S-Bahn: Anytime (separate bike ticket €2.20)
- U-Bahn: Off-peak (before 6am, 9am-2pm, after 5:30pm)
- Regional trains: Bike ticket required
- Buses: Usually not allowed

### Tips
- Use bike carriages (marked)
- Peak hours very cramped
- Consider folding bike for flexibility

## Bike Repair

### Self-Repair
- **Flickzeug**: Patch kit essential
- **Pump**: Mini-pump for emergencies
- **Multi-tool**: Basic adjustments
- **YouTube**: Good tutorials

### Repair Shops
- Many in every neighborhood
- €10-20 for basic repairs
- Full service: €50-100
- Book ahead in spring (busy season)

### Self-Service Stations
- Increasing in public spaces
- Tools on chains
- Air pumps available

## Cargo Bikes

### Types
- **Bakfiets**: Box in front (kids, cargo)
- **Longtail**: Extended rear (cargo)
- **E-cargo**: Electric assist

### Rental/Sharing
- **fLotte Berlin**: Free cargo bike sharing
- **ADFC**: Short-term rental
- **Swapfiets**: Subscription

### Buying
- €2,000-6,000 (standard)
- €4,000-10,000 (electric)
- Popular for families
