# Berlin Culture & Customs

## Berlin vs Germany

Berlin is NOT typical Germany. Key differences:

| Aspect | Germany | Berlin |
|--------|---------|--------|
| Punctuality | Sacred | More relaxed |
| Dress code | Conservative | Casual, black |
| Nightlife | Ends at 2am | 24/7 |
| English | Limited | Widely spoken |
| Politics | Varied | Left-leaning |
| Formality | High | Low |
| Rules | Followed | Questioned |

## Cultural Norms

### Greetings
- **Hallo**: Standard greeting (not formal "Guten Tag")
- **Tschüss**: Casual goodbye
- **Handshake**: Business, first meeting
- **Hugs**: Friends, after knowing someone
- **Kisses**: Less common than other European cities

### Punctuality
- **Meetings**: Be on time (Germans wait max 15 min)
- **Social**: More flexible in Berlin, but don't be late
- **Appointments**: Arrive 5 min early
- **Trains**: Leave on time (platform, not you)

### Communication Style
- **Direct**: Germans say what they mean
- **Not rude**: Just honest
- **Complaints**: Normal, not personal
- **Small talk**: Less than US/UK
- **Privacy**: Respected, don't overshare initially

### In Public
- **Volume**: Keep it down (especially transit)
- **Personal space**: Respected
- **Queue**: Germans queue properly
- **Staring**: More common than US (not hostile)
- **Smile**: Less random smiling than US

### At Home
- **Shoes off**: Always ask, usually yes
- **Quiet hours**: 10pm-6am, Sundays
- **Recycling**: Expected, bins provided
- **Guests**: Bring something (wine, flowers)

## Social Life

### Making Friends
- **Challenge**: Germans slow to open up
- **Work**: Often best entry point
- **Sports**: Join a Verein (club)
- **Hobbies**: Classes, groups
- **Expat events**: Easier start, less integration
- **Patience**: Takes 1-2 years for real friendships

### Stammtisch Culture
- Regular meetup at same place/time
- Common for hobbies, professions
- Good way to meet people
- Check Meetup.com

### Dating
- **Apps**: Tinder, Bumble, Hinge active
- **Pace**: Slower than US, faster than traditional German
- **Splitting bills**: Common
- **Directness**: Communication style carries over

## Work Culture

### Office Norms
- **Hours**: 9-18:00 typical, leaving on time OK
- **Vacation**: 25-30 days, use them all
- **Sick leave**: Call in, no questions (6 weeks paid)
- **Hierarchy**: Flatter than traditional German
- **Meetings**: Start and end on time

### Email/Communication
- **Du vs Sie**: Tech mostly "Du", ask if unsure
- **Email format**: More formal than US startup
- **Response time**: Don't expect instant
- **After hours**: Not expected to reply

### Career
- **Job hopping**: Becoming normal (wasn't traditionally)
- **Negotiation**: Expected, do it
- **Contracts**: Read everything (German love contracts)
- **Probation**: 6 months standard

## Berlin Identity

### What Berliners Value
- **Anti-establishment**: Questioning authority
- **Diversity**: Pride in multiculturalism
- **Creativity**: Art, music, alternative culture
- **History awareness**: WWII, Cold War, reunification
- **Green consciousness**: Bikes, recycling, parks
- **Nightlife**: Cultural institution, not just partying
- **Affordability**: Resisting gentrification

### Local Pride
- **Kiez**: Neighborhood identity strong
- **East vs West**: Historical divide, fading but present
- **FC Union vs Hertha**: Football identity
- **Anti-tourist sentiment**: Exists, mostly about respect

### Taboos
- **Nazi references**: Never joke about it
- **Holocaust**: Treat with respect
- **Gentrification**: Sensitive topic
- **Tourist behavior**: Don't be loud/disrespectful

## Etiquette Tips

### Dining
- **Splitting bills**: Normal ("Getrennt oder zusammen?")
- **Tipping**: 5-10%, not 20%
- **Toasting**: Eye contact, say "Prost"
- **Waiting to eat**: Until everyone served

### Shopping
- **Bring bags**: Charge for bags
- **Cash ready**: Many places cash-only
- **Closing time**: Means closing time
- **Sunday**: Shops closed

### Transit
- **Quiet carriages**: Respect them
- **Elderly/pregnant**: Offer seat
- **Bikes**: Designated areas
- **No eating**: Strong smells frowned upon

## Holidays

### Public Holidays (Berlin)
- Jan 1: New Year
- Mar 8: International Women's Day (Berlin only)
- Easter: Friday + Monday
- May 1: Labour Day (protests in Kreuzberg)
- Ascension Day
- Whit Monday
- Oct 3: German Unity Day
- Dec 25-26: Christmas

### Notable Events
- **Carnival of Cultures**: May (Kreuzberg parade)
- **Berlinale**: February (film festival)
- **Fête de la Musique**: June 21 (free music)
- **Christmas Markets**: Nov-Dec
