# Berlin Weather & Seasons

## Annual Overview

Berlin has a continental climate with distinct seasons:

| Season | Months | Temperature | Daylight |
|--------|--------|-------------|----------|
| Spring | Mar-May | 5-18°C | Increasing |
| Summer | Jun-Aug | 18-30°C | 5am-9:30pm |
| Fall | Sep-Nov | 5-15°C | Decreasing |
| Winter | Dec-Feb | -5 to 5°C | 8am-4pm |

## Month by Month

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| Jan | 3°C | -2°C | 10 | Coldest, grey |
| Feb | 4°C | -2°C | 9 | Still cold |
| Mar | 9°C | 1°C | 8 | Spring starts |
| Apr | 14°C | 4°C | 8 | Unpredictable |
| May | 19°C | 9°C | 9 | Pleasant |
| Jun | 22°C | 12°C | 10 | Best month |
| Jul | 25°C | 14°C | 9 | Warmest |
| Aug | 24°C | 14°C | 9 | Still summer |
| Sep | 19°C | 10°C | 8 | Fall begins |
| Oct | 13°C | 6°C | 8 | Golden fall |
| Nov | 7°C | 2°C | 9 | Grey starts |
| Dec | 4°C | 0°C | 10 | Dark, cold |

## Seasonal Details

### Summer (Jun-Aug)
**Best time to visit**

- **Temperature**: 20-30°C, occasionally 35°C+ heat waves
- **Daylight**: Sunrise 5am, sunset 9:30pm
- **Activities**: 
  - Lakes (Wannsee, Müggelsee, Schlachtensee)
  - Beer gardens
  - Open-air cinemas
  - Outdoor clubs
  - Tempelhof picnics

**What to pack**:
- Light clothes
- Sunscreen (you will burn)
- Light jacket for evenings
- Rain layer (summer storms)

### Winter (Dec-Feb)
**Challenging but cozy**

- **Temperature**: -5 to 5°C, occasionally -15°C
- **Daylight**: Sunrise 8am, sunset 4pm (brutal)
- **Snow**: Occasional, doesn't last long
- **Reality**: Grey. Very grey. Days of no sun.

**What to pack**:
- Warm coat (down or wool)
- Layers (heated indoors)
- Waterproof boots
- Hat, gloves, scarf
- Good moisturizer

**Survival tips**:
- Light therapy lamps help (Tageslichtlampe)
- Vitamin D supplements common
- Embrace indoor culture (cafes, museums, saunas)
- Christmas markets make December magical
- Plan trips to sun if possible

### Spring (Mar-May)
**Unpredictable but hopeful**

- Temperature swings wildly
- May can be summer-like or cold
- Cherry blossoms in April
- Parks come alive

**Pack**: Layers, umbrella, optimism

### Fall (Sep-Nov)
**Beautiful then grey**

- September/October: Golden, pleasant
- November: Grey begins, prepare mentally
- Great for museums, indoor culture

## Weather Patterns

### Rain
- Spread throughout year
- Summer: Short thunderstorms (afternoon)
- Winter: Drizzle, grey clouds
- Annual: ~570mm (similar to London but less frequent)

### Wind
- Generally not extreme
- Can feel colder in winter
- Cycling usually fine

### Extremes
- **Heat waves**: Becoming more common (35°C+)
- **Cold snaps**: Rare now (-15°C possible)
- **Snow**: A few days per year typically
- **Thunderstorms**: Summer afternoon specials

## Seasonal Activities

### Summer Must-Dos
- [ ] Lake swim (Schlachtensee, Wannsee)
- [ ] Badeschiff (floating pool)
- [ ] Open-air cinema
- [ ] Beer garden evening
- [ ] Tempelhof sunset picnic
- [ ] Club garden parties
- [ ] Canal-side drinks

### Winter Must-Dos
- [ ] Christmas markets
- [ ] Sauna visit
- [ ] Museum marathon
- [ ] Cozy cafe afternoon
- [ ] Ice skating (Potsdamer Platz)
- [ ] Theater/opera
- [ ] Spa day

## What to Wear

### Summer
- Light dresses, shorts
- Comfortable walking shoes
- Sunglasses
- Light cardigan for AC/evening

### Winter
- Layers (buildings are heated)
- Waterproof outer layer
- Warm boots (wet sidewalks)
- Accessories (hat, gloves)

### Year-Round Berlin Style
- Casual, understated
- Black is always safe
- Comfort over fashion
- Sneakers acceptable everywhere
- Overdressing stands out
